/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.system.graph;

import com.dianping.cat.consumer.metric.model.entity.MetricReport;
import com.dianping.cat.consumer.metric.model.entity.Statistic;
import com.dianping.cat.report.graph.LineChart;
import com.dianping.cat.report.graph.metric.AbstractGraphCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemGraphCreator
extends AbstractGraphCreator {
    public static final String PAAS_SYSTEM = "paasSystem";
    public static final String SYSTEM_TYPE = "system";
    public static final String JVM_TYPE = "jvm";
    public static final String NGINX_TYPE = "nginx";
    private static final List<String> SYSTEM_KEY_LIST = Arrays.asList("sysCpu:avg", "iowaitCpu:avg", "niceCpu:avg", "stealCpu:avg", "userCpu:avg", "softirqCpu:avg", "idleCpu:avg", "irqCpu:avg", "/-usage:avg", "/-freeInodes:avg", "/-read:sum", "/-write:sum", "/data-usage:avg", "/data-freeInodes:avg", "/data-read:sum", "/data-write:sum", "/usr-usage:avg", "/usr-freeInodes:avg", "/usr-read:sum", "/usr-write:sum", "/var-usage:avg", "/var-freeInodes:avg", "/var-read:sum", "/var-write:sum", "eth0-inFlow:sum", "eth0-outFlow:sum", "eth0-dropped:sum", "eth0-errors:sum", "eth0-collisions:sum", "lo-inFlow:sum", "lo-outFlow:sum", "swapUsage:avg", "loadAvg1:avg", "loadAvg5:avg", "totalMem:avg", "usedMem:avg", "freeMem:avg", "sharedMem:avg", "buffersMem:avg", "cachedMem:avg", "totalProcess:avg", "runningProcess:avg", "swapUsage:avg", "establishedTcp:avg", "loginUsers:avg");
    private static final List<String> PAAS_SYSTEM_KEY_LIST = Arrays.asList("sysCpu:avg", "userCpu:avg", "cpuUsage:avg", "/-usage:avg", "/-freeInodes:avg", "/-read:sum", "/-write:sum", "eth0-inFlow:sum", "eth0-outFlow:sum", "eth0-dropped:sum", "eth0-errors:sum", "eth0-collisions:sum", "lo-inFlow:sum", "lo-outFlow:sum", "swapUsage:avg", "totalMem:avg", "usedMem:avg", "freeMem:avg", "sharedMem:avg", "buffersMem:avg", "cachedMem:avg", "totalProcess:avg", "runningProcess:avg", "swapUsage:avg", "establishedTcp:avg", "loginUsers:avg");
    private static final List<String> JVM_KEY_LIST = new ArrayList<String>(Arrays.asList("edenUsage:avg", "oldUsage:avg", "permUsage:avg", "catalinaLogSize:sum"));
    private static final List<String> NGINX_KEY_LIST = new ArrayList();

    public Map<String, LineChart> buildChartsByProductLine(String productLine, Map<String, String> pars, Set<String> ipAddrs, Date startDate, Date endDate) {
        String type = this.filterType(pars);
        Map oldCurrentValues = this.prepareAllData(productLine, pars, ipAddrs, startDate, endDate);
        Map allCurrentValues = this.m_dataExtractor.extract(oldCurrentValues);
        Map dataWithOutFutures = this.removeFutureData(endDate, allCurrentValues);
        Set curIpAddrs = this.buildIpAddrs(pars.get("ip"), ipAddrs);
        Map aggregationKeys = this.buildLineChartKeys(dataWithOutFutures.keySet(), curIpAddrs, type);
        return this.buildChartData(oldCurrentValues, startDate, endDate, dataWithOutFutures, aggregationKeys);
    }

    private String filterType(Map<String, String> pars) {
        String type = pars.get("type");
        if (PAAS_SYSTEM.equals(type)) {
            type = PAAS_SYSTEM;
            pars.put("type", SYSTEM_TYPE);
        }
        return type;
    }

    private Set<String> buildIpAddrs(String ipPar, Set<String> ipAll) {
        if ("All".equalsIgnoreCase(ipPar)) {
            return ipAll;
        }
        String[] curIpAddrsArray = ipPar.split("_");
        HashSet<String> curIpAddrs = new HashSet<String>(Arrays.asList(curIpAddrsArray));
        return curIpAddrs;
    }

    public Map<String, double[]> prepareAllData(String group, Map<String, String> pars, Set<String> ipAddrs, Date startDate, Date endDate) {
        long start;
        long end = endDate.getTime();
        int totalSize = (int)((end - start) / 60000L);
        LinkedHashMap<String, double[]> sourceValue = new LinkedHashMap<String, double[]>();
        int index = 0;
        for (start = startDate.getTime(); start < end; start += 3600000L) {
            MetricReport report = this.m_metricReportService.querySystemReport(group, pars, new Date(start));
            Map currentValues = this.m_pruductDataFetcher.buildGraphData(report);
            this.mergeMap(sourceValue, currentValues, totalSize, index);
            ++index;
            Statistic ipList = (Statistic)report.getStatistics().get("ipList");
            if (ipList == null) continue;
            ipAddrs.addAll(ipList.getStatisticsItems().keySet());
        }
        return sourceValue;
    }

    private Map<String, LineChart> buildChartData(Map<String, double[]> datas, Date startDate, Date endDate, Map<String, double[]> dataWithOutFutures, Map<String, Map<String, String>> aggregationKeys) {
        LinkedHashMap<String, LineChart> charts = new LinkedHashMap<String, LineChart>();
        int step = this.m_dataExtractor.getStep();
        for (Map.Entry<String, Map<String, String>> keyMapEntry : aggregationKeys.entrySet()) {
            String chartTitle = keyMapEntry.getKey();
            LineChart lineChart = new LineChart();
            lineChart.setTitle(chartTitle);
            lineChart.setHtmlTitle(chartTitle);
            lineChart.setId(chartTitle);
            lineChart.setStart(startDate);
            lineChart.setUnit(this.buildUnit(chartTitle));
            lineChart.setStep((long)step * 60000L);
            if (keyMapEntry.getValue().entrySet().isEmpty()) {
                lineChart.add("none", this.buildNoneData(startDate, endDate, 1));
            }
            for (Map.Entry<String, String> ip2MetricKey : keyMapEntry.getValue().entrySet()) {
                String key = ip2MetricKey.getValue();
                String lineTitle = ip2MetricKey.getKey();
                if (dataWithOutFutures.containsKey(key)) {
                    Map all = this.convertToMap(datas.get(key), startDate, 1);
                    Map current = this.convertToMap(dataWithOutFutures.get(key), startDate, step);
                    this.addLastMinuteData(current, all, this.m_lastMinute, endDate);
                    this.convertFlowMetric(lineChart, current, lineTitle);
                    continue;
                }
                lineChart.add(lineTitle, this.buildNoneData(startDate, endDate, 1));
            }
            charts.put(chartTitle, lineChart);
        }
        return charts;
    }

    protected List<String> fetchExpectedKeys(String type) {
        if (PAAS_SYSTEM.equalsIgnoreCase(type)) {
            return PAAS_SYSTEM_KEY_LIST;
        }
        if (SYSTEM_TYPE.equalsIgnoreCase(type)) {
            return SYSTEM_KEY_LIST;
        }
        if (JVM_TYPE.equalsIgnoreCase(type)) {
            return JVM_KEY_LIST;
        }
        if (NGINX_TYPE.equalsIgnoreCase(type)) {
            return NGINX_KEY_LIST;
        }
        return new ArrayList<String>();
    }

    private Map<String, Map<String, String>> buildLineChartKeys(Set<String> Allkeys, Set<String> ipAddrs, String type) {
        List expectedKeys = this.fetchExpectedKeys(type);
        LinkedHashMap<String, Map<String, String>> aggregationKeys = new LinkedHashMap<String, Map<String, String>>();
        for (String expectedKey : expectedKeys) {
            int typeIndex = expectedKey.lastIndexOf(":");
            String metricType = expectedKey.substring(typeIndex + 1);
            String headKey = expectedKey.substring(0, typeIndex);
            HashSet<String> pidSuffixs = new HashSet<String>();
            if (JVM_TYPE.equalsIgnoreCase(type)) {
                for (String key : Allkeys) {
                    String prefix;
                    if (!key.startsWith(prefix = headKey + "@")) continue;
                    String pid = key.substring(key.indexOf("@") + 1, key.lastIndexOf("_"));
                    String pidSuffix = "@" + pid;
                    pidSuffixs.add(pidSuffix);
                }
            }
            Map ipMap = this.findOrCreate(headKey, aggregationKeys);
            for (String ip : ipAddrs) {
                if (pidSuffixs.size() <= 1) {
                    ipMap.put(ip, headKey + "_" + ip + ":" + metricType.toUpperCase());
                    continue;
                }
                for (String suffix : pidSuffixs) {
                    ipMap.put(ip + suffix, headKey + suffix + "_" + ip + ":" + metricType.toUpperCase());
                }
            }
        }
        return aggregationKeys;
    }

    private Map<String, String> findOrCreate(String key, Map<String, Map<String, String>> aggregationKeys) {
        Map<String, String> ipMap = aggregationKeys.get(key);
        if (ipMap == null) {
            ipMap = new HashMap<String, String>();
            aggregationKeys.put(key, ipMap);
        }
        return ipMap;
    }
}

