/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.system.graph;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.metric.model.entity.MetricItem;
import com.dianping.cat.consumer.metric.model.entity.MetricReport;
import com.dianping.cat.consumer.metric.model.entity.Segment;
import com.dianping.cat.consumer.metric.model.transform.BaseVisitor;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemReportConvertor
extends BaseVisitor {
    private String m_type;
    private Set<String> m_ipAddrs;
    private String m_chartKey;
    private MetricReport m_report;
    public static final String IP_LIST_KEY = "ipList";

    public SystemReportConvertor(String type, Set<String> ipAddrs) {
        this.m_type = type;
        this.m_ipAddrs = ipAddrs;
    }

    public MetricReport getReport() {
        return this.m_report;
    }

    public void visitMetricItem(MetricItem metricItem) {
        try {
            if (this.validate(metricItem.getId())) {
                MetricItem item = this.m_report.findOrCreateMetricItem(this.m_chartKey);
                item.setType(metricItem.getType());
                this.mergeMetricItem(item, metricItem);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }

    public void mergeMetricItem(MetricItem to, MetricItem from) {
        for (Segment temp : from.getSegments().values()) {
            Segment target = to.findOrCreateSegment(temp.getId());
            this.mergeSegment(target, temp);
        }
    }

    protected void mergeSegment(Segment to, Segment from) {
        to.setCount(from.getCount());
        to.setSum(from.getSum());
        to.setAvg(from.getAvg());
    }

    private boolean validate(String id) {
        try {
            int index = id.indexOf(":", id.indexOf(":") + 1);
            String realKey = id.substring(index + 1);
            int typeIndex = realKey.indexOf("_");
            String type = realKey.substring(0, typeIndex);
            int ipIndex = realKey.lastIndexOf("_");
            String chartKey = realKey.substring(typeIndex + 1, ipIndex);
            String ip = realKey.substring(ipIndex + 1);
            this.m_report.findOrCreateStatistic(IP_LIST_KEY).findOrCreateStatisticsItem(ip);
            if (this.m_type.equals(type)) {
                this.m_chartKey = chartKey + "_" + ip;
                return this.m_ipAddrs == null || this.m_ipAddrs.contains(ip);
            }
            return false;
        }
        catch (Exception e) {
            Cat.logError((Throwable)new RuntimeException("system agent send metric [" + id + "]  error"));
            return false;
        }
    }

    public void visitMetricReport(MetricReport metricReport) {
        this.m_report = new MetricReport(metricReport.getProduct());
        this.m_report.setStartTime(metricReport.getStartTime());
        this.m_report.setEndTime(metricReport.getEndTime());
        super.visitMetricReport(metricReport);
    }

    public void visitSegment(Segment segment) {
        super.visitSegment(segment);
    }
}

