/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.top;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.problem.model.entity.ProblemReport;
import com.dianping.cat.consumer.top.model.IVisitor;
import com.dianping.cat.consumer.top.model.entity.TopReport;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.helper.JsonBuilder;
import com.dianping.cat.mvc.AbstractReportModel;
import com.dianping.cat.mvc.AbstractReportPayload;
import com.dianping.cat.mvc.PayloadNormalizer;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.alert.exception.ExceptionRuleConfigManager;
import com.dianping.cat.report.page.dependency.ExternalInfoBuilder;
import com.dianping.cat.report.page.dependency.TopExceptionExclude;
import com.dianping.cat.report.page.dependency.TopMetric;
import com.dianping.cat.report.page.state.StateBuilder;
import com.dianping.cat.report.page.top.Action;
import com.dianping.cat.report.page.top.Context;
import com.dianping.cat.report.page.top.DomainInfo;
import com.dianping.cat.report.page.top.JspViewer;
import com.dianping.cat.report.page.top.Model;
import com.dianping.cat.report.page.top.Payload;
import com.dianping.cat.report.page.top.ProblemReportVisitor;
import com.dianping.cat.report.page.top.TransactionReportVisitor;
import com.dianping.cat.report.page.top.service.TopReportService;
import com.dianping.cat.report.page.transaction.transform.TransactionMergeHelper;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Handler
implements PageHandler<Context> {
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private PayloadNormalizer m_normalizePayload;
    @Inject
    private ExternalInfoBuilder m_externalInfoBuilder;
    @Inject
    private StateBuilder m_stateBuilder;
    @Inject(type=ModelService.class, value={"top"})
    private ModelService<TopReport> m_topService;
    @Inject(type=ModelService.class, value={"transaction"})
    private ModelService<TransactionReport> m_transactionService;
    @Inject(type=ModelService.class, value={"problem"})
    private ModelService<ProblemReport> m_problemService;
    @Inject
    private TopReportService m_topReportService;
    @Inject
    private TransactionMergeHelper m_mergeHelper;
    @Inject
    private ExceptionRuleConfigManager m_configManager;
    @Inject
    private JsonBuilder m_builder;

    private void buildExceptionDashboard(Model model, Payload payload, long date) {
        model.setReportStart(new Date(payload.getDate()));
        model.setReportEnd(new Date(payload.getDate() + 3600000L - 1L));
        int minuteCount = payload.getMinuteCounts();
        int minute = model.getMinute();
        TopReport report = this.queryTopReport(payload);
        List<String> excludeDomains = Arrays.asList("FrontEnd");
        TopMetric topMetric = new TopMetric(minuteCount, payload.getTopCounts(), this.m_configManager, excludeDomains);
        Date end = new Date(payload.getDate() + 60000L * (long)minute);
        Date start = new Date(end.getTime() - 60000L * (long)minuteCount);
        topMetric.setStart(start).setEnd(end);
        if (minuteCount > minute) {
            Payload lastPayload = new Payload();
            Date lastHour = new Date(payload.getDate() - 3600000L);
            lastPayload.setDate(new SimpleDateFormat("yyyyMMddHH").format(lastHour));
            TopReport lastReport = this.queryTopReport(lastPayload);
            topMetric.visitTopReport(lastReport);
            model.setLastTopReport(lastReport);
        }
        topMetric.visitTopReport(report);
        model.setTopReport(report);
        model.setTopMetric(topMetric);
    }

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="top")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="top")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        Action action = payload.getAction();
        model.setAction((org.unidal.web.mvc.Action)action);
        model.setPage((Page)ReportPage.TOP);
        this.normalize(model, payload);
        long date = payload.getDate();
        if (action == Action.HEALTH) {
            DomainInfo info = this.buildDomainInfo(payload, model);
            ctx.getHttpServletResponse().getWriter().write(this.m_builder.toJson((Object)info));
        } else {
            this.buildExceptionDashboard(model, payload, date);
            model.setMessage(this.m_stateBuilder.buildStateMessage(payload.getDate(), payload.getIpAddress()));
            if (action == Action.VIEW) {
                if (!ctx.isProcessStopped()) {
                    this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
                }
            } else if (action == Action.API) {
                ctx.getHttpServletResponse().getWriter().write(this.m_builder.toJson((Object)model.getTopMetric()));
            }
        }
    }

    private void normalize(Model model, Payload payload) {
        model.setPage((Page)ReportPage.TOP);
        model.setAction((org.unidal.web.mvc.Action)Action.VIEW);
        this.m_normalizePayload.normalize((AbstractReportModel)model, (AbstractReportPayload)payload);
        Integer minute = this.parseQueryMinute(payload);
        int maxMinute = 60;
        ArrayList<Integer> minutes = new ArrayList<Integer>();
        if (payload.getPeriod().isCurrent()) {
            long current = payload.getCurrentTimeMillis() / 1000L / 60L;
            maxMinute = (int)(current % 60L);
        }
        for (int i = 0; i < 60; ++i) {
            minutes.add(i);
        }
        model.setMinute(minute.intValue());
        model.setMaxMinute(maxMinute);
        model.setMinutes(minutes);
    }

    private int parseQueryMinute(Payload payload) {
        int minute = 0;
        String min = payload.getMinute();
        if (StringUtils.isEmpty((String)min)) {
            long current = payload.getCurrentTimeMillis() / 1000L / 60L;
            minute = (int)(current % 60L);
        } else {
            minute = Integer.parseInt(min);
        }
        return minute;
    }

    private DomainInfo buildDomainInfo(Payload payload, Model model) {
        long date = payload.getDate();
        int minute = model.getMinute();
        int exceptedMinute = payload.getMinuteCounts();
        DomainInfo info = new DomainInfo();
        if (minute < exceptedMinute) {
            this.buildTransactionInfo(payload, date - 3600000L, info);
            this.buildProblemInfo(payload, date - 3600000L, info);
        }
        this.buildTransactionInfo(payload, date, info);
        this.buildProblemInfo(payload, date, info);
        Map metrics = info.getMetrics();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        long end = date + (long)minute * 60000L;
        long start = end - (long)exceptedMinute * 60000L;
        HashSet<String> removed = new HashSet<String>();
        for (Map.Entry entry : metrics.entrySet()) {
            String key = (String)entry.getKey();
            try {
                long d = sdf.parse(key).getTime();
                if (d > start && d <= end) continue;
                removed.add(key);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        for (String s : removed) {
            metrics.remove(s);
        }
        return info;
    }

    private TopReport queryTopReport(Payload payload) {
        String domain = "cat";
        String date = String.valueOf(payload.getDate());
        ModelRequest request = new ModelRequest(domain, payload.getDate()).setProperty("date", date);
        if (this.m_topService.isEligable(request)) {
            ModelResponse response = this.m_topService.invoke(request);
            TopReport report = (TopReport)response.getModel();
            if (report == null || report.getDomains().size() == 0) {
                report = (TopReport)this.m_topReportService.queryReport(domain, new Date(payload.getDate()), new Date(payload.getDate() + 3600000L));
            }
            report.accept((IVisitor)new TopExceptionExclude(this.m_configManager));
            return report;
        }
        throw new RuntimeException("Internal error: no eligable top service registered for " + request + "!");
    }

    private void buildTransactionInfo(Payload payload, long date, DomainInfo info) {
        String domain = payload.getDomain();
        String ipAddress = payload.getIpAddress();
        if (StringUtils.isEmpty((String)ipAddress)) {
            ipAddress = "All";
        }
        TransactionReport urlReport = this.quertTrasactionReport(domain, ipAddress, date, "URL");
        TransactionReport serviceReport = this.quertTrasactionReport(domain, ipAddress, date, "PigeonService");
        new TransactionReportVisitor(ipAddress, info, "URL").visitTransactionReport(urlReport);
        new TransactionReportVisitor(ipAddress, info, "PigeonService").visitTransactionReport(serviceReport);
    }

    private void buildProblemInfo(Payload payload, long date, DomainInfo info) {
        String domain = payload.getDomain();
        String ipAddress = payload.getIpAddress();
        if (StringUtils.isEmpty((String)ipAddress)) {
            ipAddress = "All";
        }
        ProblemReport report = this.queryProblemReport(domain, ipAddress, date, "error");
        new ProblemReportVisitor(ipAddress, info, "error").visitProblemReport(report);
    }

    private TransactionReport quertTrasactionReport(String domain, String ipAddress, long date, String type) {
        ModelRequest request = new ModelRequest(domain, date).setProperty("type", type).setProperty("name", "All").setProperty("ip", ipAddress);
        if (this.m_transactionService.isEligable(request)) {
            ModelResponse response = this.m_transactionService.invoke(request);
            TransactionReport report = (TransactionReport)response.getModel();
            report = this.m_mergeHelper.mergeAllMachines(report, ipAddress);
            return report;
        }
        throw new RuntimeException("Internal error: no eligable transaction service registered for " + request + "!");
    }

    private ProblemReport queryProblemReport(String domain, String ipAddress, long date, String type) {
        ModelRequest request = new ModelRequest(domain, date).setProperty("type", type).setProperty("queryType", "detail");
        if (!"All".equals(ipAddress)) {
            request.setProperty("ip", ipAddress);
        }
        if (this.m_problemService.isEligable(request)) {
            ModelResponse response = this.m_problemService.invoke(request);
            ProblemReport report = (ProblemReport)response.getModel();
            return report;
        }
        throw new RuntimeException("Internal error: no eligible problem service registered for " + request + "!");
    }
}

