/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.transaction;

import com.dianping.cat.consumer.transaction.model.entity.TransactionName;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.consumer.transaction.model.entity.TransactionType;
import com.dianping.cat.report.page.transaction.DisplayNames;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayNames {
    private List<TransactionNameModel> m_results = new ArrayList();

    public DisplayNames display(String sorted, String type, String ip, TransactionReport report, String queryName) {
        TransactionType names;
        Map types = report.findOrCreateMachine(ip).getTypes();
        TransactionName all = new TransactionName("TOTAL");
        all.setTotalPercent(1.0);
        if (types != null && (names = (TransactionType)types.get(type)) != null) {
            for (Map.Entry entry : names.getNames().entrySet()) {
                String transTypeName = ((TransactionName)entry.getValue()).getId();
                boolean isAdd = queryName == null || queryName.length() == 0 || this.isFit(queryName, transTypeName);
                if (!isAdd) continue;
                this.m_results.add(new TransactionNameModel((String)entry.getKey(), (TransactionName)entry.getValue()));
                this.mergeName(all, (TransactionName)entry.getValue());
            }
        }
        if (sorted == null) {
            sorted = "avg";
        }
        Collections.sort(this.m_results, new TransactionNameComparator(sorted));
        long total = all.getTotalCount();
        for (TransactionNameModel nameModel : this.m_results) {
            TransactionName transactionName = nameModel.getDetail();
            transactionName.setTotalPercent((double)transactionName.getTotalCount() / (double)total);
        }
        this.m_results.add(0, new TransactionNameModel("TOTAL", all));
        return this;
    }

    public List<TransactionNameModel> getResults() {
        return this.m_results;
    }

    private boolean isFit(String queryName, String transactionName) {
        String[] args = queryName.split("\\|");
        if (args != null) {
            for (String str : args) {
                if (str.length() <= 0 || !transactionName.toLowerCase().contains(str.trim().toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    private void mergeName(TransactionName old, TransactionName other) {
        old.setTotalCount(old.getTotalCount() + other.getTotalCount());
        old.setFailCount(old.getFailCount() + other.getFailCount());
        if (other.getMin() < old.getMin()) {
            old.setMin(other.getMin());
        }
        if (other.getMax() > old.getMax()) {
            old.setMax(other.getMax());
        }
        old.setSum(old.getSum() + other.getSum());
        old.setSum2(old.getSum2() + other.getSum2());
        old.setLine95Value(0.0);
        old.setLine99Value(0.0);
        if (old.getTotalCount() > 0L) {
            old.setFailPercent((double)old.getFailCount() * 100.0 / (double)old.getTotalCount());
            old.setAvg(old.getSum() / (double)old.getTotalCount());
            old.setStd(this.std(old.getTotalCount(), old.getAvg(), old.getSum2(), old.getMax()));
        }
        if (old.getSuccessMessageUrl() == null) {
            old.setSuccessMessageUrl(other.getSuccessMessageUrl());
        }
        if (old.getFailMessageUrl() == null) {
            old.setFailMessageUrl(other.getFailMessageUrl());
        }
    }

    private double std(long count, double avg, double sum2, double max) {
        double value = sum2 / (double)count - avg * avg;
        if (value <= 0.0 || count <= 1L) {
            return 0.0;
        }
        if (count == 2L) {
            return max - avg;
        }
        return Math.sqrt(value);
    }
}

