/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.transaction;

import com.dianping.cat.Cat;
import com.dianping.cat.core.dal.DailyGraph;
import com.dianping.cat.core.dal.DailyGraphDao;
import com.dianping.cat.core.dal.DailyGraphEntity;
import com.dianping.cat.core.dal.Graph;
import com.dianping.cat.core.dal.GraphDao;
import com.dianping.cat.core.dal.GraphEntity;
import com.dianping.cat.report.graph.LineChart;
import com.dianping.cat.report.page.BaseHistoryGraphs;
import com.dianping.cat.report.page.transaction.Handler;
import com.dianping.cat.report.page.transaction.Model;
import com.dianping.cat.report.page.transaction.Payload;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryGraphs
extends BaseHistoryGraphs {
    public static final double NOTEXIST = 0.0;
    @Inject
    private GraphDao m_graphDao;
    @Inject
    private DailyGraphDao m_dailyGraphDao;

    private void appendArray(double[] src, int index, String str, int size) {
        String[] values = str.split(",");
        int valueSize = values.length;
        if (valueSize <= 12) {
            for (int i = 0; i < valueSize; ++i) {
                for (int j = 0; j < 5; ++j) {
                    src[index + i * 5 + j] = Double.valueOf(values[i]) / 5.0;
                }
            }
        } else {
            for (int i = 0; i < size; ++i) {
                src[index + i] = Double.valueOf(values[i]);
            }
        }
    }

    private LineChart buildAvg(List<Map<String, double[]>> datas, Date start, int size, long step, String name, String queryType) {
        LineChart item = new LineChart();
        item.setStart(start);
        item.setSize(size);
        item.setStep(step);
        item.setTitle(name + " Response Time (ms)");
        for (Map<String, double[]> data : datas) {
            double[] sum = data.get("sum");
            double[] totalCount = data.get("total_count");
            double[] avg = new double[sum.length];
            for (int i = 0; i < sum.length; ++i) {
                if (!(totalCount[i] > 0.0)) continue;
                avg[i] = sum[i] / totalCount[i];
            }
            item.addValue(avg);
        }
        item.setSubTitles(this.buildSubTitle(start, size, step, queryType));
        return item;
    }

    private LineChart buildFail(List<Map<String, double[]>> datas, Date start, int size, long step, String name, String queryType) {
        LineChart item = new LineChart();
        item.setStart(start);
        item.setSize(size);
        item.setStep(step);
        item.setTitle(name + " Error (count)");
        for (Map<String, double[]> data : datas) {
            item.addValue(data.get("failure_count"));
        }
        item.setSubTitles(this.buildSubTitle(start, size, step, queryType));
        return item;
    }

    public Map<String, double[]> buildGraphDatasForDaily(Date start, Date end, String type, String name, List<DailyGraph> graphs) {
        HashMap<String, double[]> result = new HashMap<String, double[]>();
        int size = (int)((end.getTime() - start.getTime()) / 86400000L);
        double[] totalCount = new double[size];
        double[] failureCount = new double[size];
        double[] sum = new double[size];
        for (int i = 0; i < size; ++i) {
            totalCount[i] = 0.0;
            failureCount[i] = 0.0;
            sum[i] = 0.0;
        }
        if (!StringUtils.isEmpty((String)type) && StringUtils.isEmpty((String)name)) {
            for (DailyGraph graph : graphs) {
                int indexOfperiod = (int)((graph.getPeriod().getTime() - start.getTime()) / 86400000L);
                String summaryContent = graph.getSummaryContent();
                String[] allLines = summaryContent.split("\n");
                for (int j = 0; j < allLines.length; ++j) {
                    String[] records = allLines[j].split("\t");
                    if (!records[Handler.SummaryOrder.TYPE.ordinal()].equals(type)) continue;
                    totalCount[indexOfperiod] = Double.valueOf(records[Handler.SummaryOrder.TOTAL_COUNT.ordinal()]);
                    failureCount[indexOfperiod] = Double.valueOf(records[Handler.SummaryOrder.FAILURE_COUNT.ordinal()]);
                    sum[indexOfperiod] = Double.valueOf(records[Handler.SummaryOrder.SUM.ordinal()]);
                }
            }
        } else if (!StringUtils.isEmpty((String)type) && !StringUtils.isEmpty((String)name)) {
            for (DailyGraph graph : graphs) {
                int indexOfperiod = (int)((graph.getPeriod().getTime() - start.getTime()) / 86400000L);
                String detailContent = graph.getDetailContent();
                String[] allLines = detailContent.split("\n");
                for (int j = 0; j < allLines.length; ++j) {
                    String[] records = allLines[j].split("\t");
                    if (!records[Handler.DetailOrder.TYPE.ordinal()].equals(type) || !records[Handler.DetailOrder.NAME.ordinal()].equals(name)) continue;
                    totalCount[indexOfperiod] = Double.valueOf(records[Handler.DetailOrder.TOTAL_COUNT.ordinal()]);
                    failureCount[indexOfperiod] = Double.valueOf(records[Handler.DetailOrder.FAILURE_COUNT.ordinal()]);
                    sum[indexOfperiod] = Double.valueOf(records[Handler.DetailOrder.SUM.ordinal()]);
                }
            }
        }
        result.put("total_count", totalCount);
        result.put("failure_count", failureCount);
        result.put("sum", sum);
        return result;
    }

    public Map<String, double[]> buildGraphDatasForHour(Date start, Date end, String type, String name, List<Graph> graphs) {
        HashMap<String, double[]> result = new HashMap<String, double[]>();
        int size = (int)((end.getTime() - start.getTime()) * 60L / 3600000L);
        double[] total_count = new double[size];
        double[] failure_count = new double[size];
        double[] sum = new double[size];
        for (int i = 0; i < size; ++i) {
            total_count[i] = 0.0;
            failure_count[i] = 0.0;
            sum[i] = 0.0;
        }
        if (!StringUtils.isEmpty((String)type) && StringUtils.isEmpty((String)name)) {
            for (Graph graph : graphs) {
                int indexOfperiod = (int)((graph.getPeriod().getTime() - start.getTime()) * 60L / 3600000L);
                String summaryContent = graph.getSummaryContent();
                String[] allLines = summaryContent.split("\n");
                for (int j = 0; j < allLines.length; ++j) {
                    String[] records = allLines[j].split("\t");
                    if (!records[Handler.SummaryOrder.TYPE.ordinal()].equals(type)) continue;
                    this.appendArray(total_count, indexOfperiod, records[Handler.SummaryOrder.TOTAL_COUNT.ordinal()], 60);
                    this.appendArray(failure_count, indexOfperiod, records[Handler.SummaryOrder.FAILURE_COUNT.ordinal()], 60);
                    this.appendArray(sum, indexOfperiod, records[Handler.SummaryOrder.SUM.ordinal()], 60);
                }
            }
        } else if (!StringUtils.isEmpty((String)type) && !StringUtils.isEmpty((String)name)) {
            for (Graph graph : graphs) {
                int indexOfperiod = (int)((graph.getPeriod().getTime() - start.getTime()) * 60L / 3600000L);
                String detailContent = graph.getDetailContent();
                String[] allLines = detailContent.split("\n");
                for (int j = 0; j < allLines.length; ++j) {
                    String[] records = allLines[j].split("\t");
                    if (!records[Handler.DetailOrder.TYPE.ordinal()].equals(type) || !records[Handler.DetailOrder.NAME.ordinal()].equals(name)) continue;
                    this.appendArray(total_count, indexOfperiod, records[Handler.DetailOrder.TOTAL_COUNT.ordinal()], 60);
                    this.appendArray(failure_count, indexOfperiod, records[Handler.DetailOrder.FAILURE_COUNT.ordinal()], 60);
                    this.appendArray(sum, indexOfperiod, records[Handler.DetailOrder.SUM.ordinal()], 60);
                }
            }
        }
        result.put("total_count", total_count);
        result.put("failure_count", failure_count);
        result.put("sum", sum);
        return result;
    }

    public void buildGroupTrendGraph(Model model, Payload payload, List<String> ips) {
        Date start = payload.getHistoryStartDate();
        Date end = payload.getHistoryEndDate();
        String domain = model.getDomain();
        String type = payload.getType();
        String name = payload.getName();
        String display = name != null ? name : type;
        int size = (int)((end.getTime() - start.getTime()) * 60L / 3600000L);
        long step = 60000L;
        String queryType = payload.getReportType();
        if (queryType.equalsIgnoreCase("week") || queryType.equalsIgnoreCase("month")) {
            size = (int)((end.getTime() - start.getTime()) / 86400000L);
            step = 86400000L;
        }
        List allDatas = null;
        for (String ip : ips) {
            List datas = this.buildLineChartData(start, end, domain, type, name, ip, queryType);
            if (allDatas == null) {
                allDatas = datas;
                continue;
            }
            this.mergerList(allDatas, datas);
        }
        LineChart item = this.buildAvg(allDatas, start, size, step, display, queryType);
        model.setResponseTrend(item.getJsonString());
        item = this.buildTotal(allDatas, start, size, step, display, queryType);
        model.setHitTrend(item.getJsonString());
        item = this.buildFail(allDatas, start, size, step, display, queryType);
        model.setErrorTrend(item.getJsonString());
    }

    private List<Map<String, double[]>> buildLineChartData(Date start, Date end, String domain, String type, String name, String ip, String queryType) {
        ArrayList<Map<String, double[]>> allDatas = new ArrayList<Map<String, double[]>>();
        if (queryType.equalsIgnoreCase("day")) {
            Map currentGraph = this.getGraphDatasFromHour(start, end, domain, type, name, ip);
            Map lastDayGraph = this.getGraphDatasFromHour(new Date(start.getTime() - 86400000L), new Date(end.getTime() - 86400000L), domain, type, name, ip);
            Map lastWeekGraph = this.getGraphDatasFromHour(new Date(start.getTime() - 604800000L), new Date(end.getTime() - 604800000L), domain, type, name, ip);
            allDatas.add(currentGraph);
            allDatas.add(lastDayGraph);
            allDatas.add(lastWeekGraph);
        } else if (queryType.equalsIgnoreCase("week")) {
            Map currentGraph = this.getGraphDatasFromDaily(start, end, domain, type, name, ip);
            Map lastWeek = this.getGraphDatasFromDaily(new Date(start.getTime() - 604800000L), new Date(end.getTime() - 604800000L), domain, type, name, ip);
            allDatas.add(currentGraph);
            allDatas.add(lastWeek);
        } else if (queryType.equalsIgnoreCase("month")) {
            Map graphData = this.getGraphDatasFromDaily(start, end, domain, type, name, ip);
            allDatas.add(graphData);
        } else {
            throw new RuntimeException("Error graph query type");
        }
        return allDatas;
    }

    private LineChart buildTotal(List<Map<String, double[]>> datas, Date start, int size, long step, String name, String queryType) {
        LineChart item = new LineChart();
        item.setStart(start);
        item.setSize(size);
        item.setStep(step);
        item.setTitle(name + " Hits (count)");
        for (Map<String, double[]> data : datas) {
            double[] totalCount = data.get("total_count");
            item.addValue(totalCount);
        }
        item.setSubTitles(this.buildSubTitle(start, size, step, queryType));
        return item;
    }

    public void buildTrendGraph(Model model, Payload payload) {
        Date start = payload.getHistoryStartDate();
        Date end = payload.getHistoryEndDate();
        String domain = model.getDomain();
        String type = payload.getType();
        String name = payload.getName();
        String ip = model.getIpAddress();
        String display = name != null ? name : type;
        int size = (int)((end.getTime() - start.getTime()) * 60L / 3600000L);
        long step = 60000L;
        String queryType = payload.getReportType();
        if (queryType.equalsIgnoreCase("month") || queryType.equalsIgnoreCase("week")) {
            size = (int)((end.getTime() - start.getTime()) / 86400000L);
            step = 86400000L;
        }
        List allDatas = this.buildLineChartData(start, end, domain, type, name, ip, queryType);
        LineChart item = this.buildAvg(allDatas, start, size, step, display, queryType);
        model.setResponseTrend(item.getJsonString());
        item = this.buildTotal(allDatas, start, size, step, display, queryType);
        model.setHitTrend(item.getJsonString());
        item = this.buildFail(allDatas, start, size, step, display, queryType);
        model.setErrorTrend(item.getJsonString());
    }

    private Map<String, double[]> getGraphDatasFromDaily(Date start, Date end, String domain, String type, String name, String ip) {
        String queryIp = "All".equalsIgnoreCase(ip) ? "All" : ip;
        ArrayList<DailyGraph> graphs = new ArrayList<DailyGraph>();
        for (long startLong = start.getTime(); startLong < end.getTime(); startLong += 86400000L) {
            try {
                DailyGraph graph = this.m_dailyGraphDao.findByDomainNameIpDate(new Date(startLong), queryIp, domain, "transaction", DailyGraphEntity.READSET_FULL);
                graphs.add(graph);
                continue;
            }
            catch (DalNotFoundException graph) {
                continue;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        return this.buildGraphDatasForDaily(start, end, type, name, graphs);
    }

    public Map<String, double[]> getGraphDatasFromHour(Date start, Date end, String domain, String type, String name, String ip) {
        String queryIp = "All".equals(ip) ? "all" : ip;
        ArrayList<Graph> graphs = new ArrayList<Graph>();
        for (long startLong = start.getTime(); startLong < end.getTime(); startLong += 3600000L) {
            try {
                Graph graph = this.m_graphDao.findSingalByDomainNameIpDuration(new Date(startLong), queryIp, domain, "transaction", GraphEntity.READSET_FULL);
                graphs.add(graph);
                continue;
            }
            catch (DalNotFoundException graph) {
                continue;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        return this.buildGraphDatasForHour(start, end, type, name, graphs);
    }
}

