/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.transaction.service;

import com.dianping.cat.consumer.transaction.TransactionReportMerger;
import com.dianping.cat.consumer.transaction.model.IEntity;
import com.dianping.cat.consumer.transaction.model.IVisitor;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.consumer.transaction.model.transform.DefaultSaxParser;
import com.dianping.cat.mvc.ApiPayload;
import com.dianping.cat.report.ReportBucket;
import com.dianping.cat.report.ReportBucketManager;
import com.dianping.cat.report.page.transaction.service.LocalTransactionService;
import com.dianping.cat.report.service.LocalModelService;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import java.util.Date;
import java.util.List;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalTransactionService
extends LocalModelService<TransactionReport> {
    public static final String ID = "transaction";
    @Inject
    private ReportBucketManager m_bucketManager;

    public LocalTransactionService() {
        super(ID);
    }

    private String filterReport(ApiPayload payload, TransactionReport report) {
        String type = payload.getType();
        String name = payload.getName();
        String ip = payload.getIpAddress();
        int min = payload.getMin();
        int max = payload.getMax();
        String xml = null;
        try {
            TransactionReportFilter filter = new TransactionReportFilter(type, name, ip, min, max);
            xml = filter.buildXml((IEntity)report);
        }
        catch (Exception e) {
            TransactionReportFilter filter = new TransactionReportFilter(type, name, ip, min, max);
            xml = filter.buildXml((IEntity)report);
        }
        return xml;
    }

    public String buildReport(ModelRequest request, ModelPeriod period, String domain, ApiPayload payload) throws Exception {
        List reports = super.getReport(period, domain);
        TransactionReport report = null;
        if (reports != null) {
            report = new TransactionReport(domain);
            TransactionReportMerger merger = new TransactionReportMerger(report);
            for (TransactionReport tmp : reports) {
                tmp.accept((IVisitor)merger);
            }
        }
        if ((report == null || report.getIps().isEmpty()) && period.isLast()) {
            long startTime = request.getStartTime();
            report = this.getReportFromLocalDisk(startTime, domain);
        }
        return this.filterReport(payload, report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionReport getReportFromLocalDisk(long timestamp, String domain) throws Exception {
        TransactionReport report = new TransactionReport(domain);
        TransactionReportMerger merger = new TransactionReportMerger(report);
        report.setStartTime(new Date(timestamp));
        report.setEndTime(new Date(timestamp + 3600000L - 1L));
        for (int i = 0; i < 2; ++i) {
            ReportBucket bucket = null;
            try {
                bucket = this.m_bucketManager.getReportBucket(timestamp, ID, i);
                String xml = bucket.findById(domain);
                if (xml != null) {
                    TransactionReport tmp = DefaultSaxParser.parse((String)xml);
                    tmp.accept((IVisitor)merger);
                    continue;
                }
                report.getDomainNames().addAll(bucket.getIds());
                continue;
            }
            finally {
                if (bucket != null) {
                    this.m_bucketManager.closeBucket(bucket);
                }
            }
        }
        return report;
    }
}

