/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.transaction.service;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.transaction.TransactionReportMerger;
import com.dianping.cat.consumer.transaction.model.IVisitor;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.consumer.transaction.model.transform.DefaultNativeParser;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.DailyReportContent;
import com.dianping.cat.core.dal.DailyReportContentEntity;
import com.dianping.cat.core.dal.DailyReportEntity;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.core.dal.HourlyReportContent;
import com.dianping.cat.core.dal.HourlyReportContentEntity;
import com.dianping.cat.core.dal.HourlyReportEntity;
import com.dianping.cat.core.dal.MonthlyReport;
import com.dianping.cat.core.dal.MonthlyReportContent;
import com.dianping.cat.core.dal.MonthlyReportContentEntity;
import com.dianping.cat.core.dal.MonthlyReportEntity;
import com.dianping.cat.core.dal.WeeklyReport;
import com.dianping.cat.core.dal.WeeklyReportContent;
import com.dianping.cat.core.dal.WeeklyReportContentEntity;
import com.dianping.cat.core.dal.WeeklyReportEntity;
import com.dianping.cat.report.page.transaction.service.TransactionReportService;
import com.dianping.cat.report.service.AbstractReportService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionReportService
extends AbstractReportService<TransactionReport> {
    private SimpleDateFormat m_sdf = new SimpleDateFormat("yyyy-MM-dd");

    private TransactionReport convert(TransactionReport report) {
        Date start = report.getStartTime();
        Date end = report.getEndTime();
        try {
            if (start != null && end != null && end.before(this.m_sdf.parse("2015-01-05"))) {
                TpsStatistics statistics = new TpsStatistics(this, (double)(end.getTime() - start.getTime()) / 1000.0);
                report.accept((IVisitor)statistics);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return report;
    }

    public TransactionReport makeReport(String domain, Date start, Date end) {
        TransactionReport report = new TransactionReport(domain);
        report.setStartTime(start);
        report.setEndTime(end);
        return report;
    }

    public TransactionReport queryDailyReport(String domain, Date start, Date end) {
        TransactionReportMerger merger = new TransactionReportMerger(new TransactionReport(domain));
        long endTime = end.getTime();
        String name = "transaction";
        for (long startTime = start.getTime(); startTime < endTime; startTime += 86400000L) {
            try {
                DailyReport report = this.m_dailyReportDao.findByDomainNamePeriod(domain, name, new Date(startTime), DailyReportEntity.READSET_FULL);
                TransactionReport reportModel = this.queryFromDailyBinary(report.getId(), domain);
                reportModel.accept((IVisitor)merger);
                continue;
            }
            catch (DalNotFoundException report) {
                continue;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        TransactionReport transactionReport = merger.getTransactionReport();
        transactionReport.setStartTime(start);
        transactionReport.setEndTime(end);
        return this.convert(transactionReport);
    }

    private TransactionReport queryFromDailyBinary(int id, String domain) throws DalException {
        DailyReportContent content = this.m_dailyReportContentDao.findByPK(id, DailyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new TransactionReport(domain);
    }

    private TransactionReport queryFromHourlyBinary(int id, String domain) throws DalException {
        HourlyReportContent content = this.m_hourlyReportContentDao.findByPK(id, HourlyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new TransactionReport(domain);
    }

    private TransactionReport queryFromMonthlyBinary(int id, String domain) throws DalException {
        MonthlyReportContent content = this.m_monthlyReportContentDao.findByPK(id, MonthlyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new TransactionReport(domain);
    }

    private TransactionReport queryFromWeeklyBinary(int id, String domain) throws DalException {
        WeeklyReportContent content = this.m_weeklyReportContentDao.findByPK(id, WeeklyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new TransactionReport(domain);
    }

    public TransactionReport queryHourlyReport(String domain, Date start, Date end) {
        TransactionReportMerger merger = new TransactionReportMerger(new TransactionReport(domain));
        long endTime = end.getTime();
        String name = "transaction";
        for (long startTime = start.getTime(); startTime < endTime; startTime += 3600000L) {
            List reports = null;
            try {
                reports = this.m_hourlyReportDao.findAllByDomainNamePeriod(new Date(startTime), domain, name, HourlyReportEntity.READSET_FULL);
            }
            catch (DalException e) {
                Cat.logError((Throwable)e);
            }
            if (reports == null) continue;
            for (HourlyReport report : reports) {
                try {
                    TransactionReport reportModel = this.queryFromHourlyBinary(report.getId(), domain);
                    reportModel.accept((IVisitor)merger);
                }
                catch (DalNotFoundException reportModel) {
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
            }
        }
        TransactionReport transactionReport = merger.getTransactionReport();
        transactionReport.setStartTime(start);
        transactionReport.setEndTime(new Date(end.getTime() - 1L));
        Set domains = this.queryAllDomainNames(start, end, "transaction");
        transactionReport.getDomainNames().addAll(domains);
        return this.convert(transactionReport);
    }

    public TransactionReport queryMonthlyReport(String domain, Date start) {
        TransactionReport transactionReport = new TransactionReport(domain);
        try {
            MonthlyReport entity = this.m_monthlyReportDao.findReportByDomainNamePeriod(start, domain, "transaction", MonthlyReportEntity.READSET_FULL);
            transactionReport = this.queryFromMonthlyBinary(entity.getId(), domain);
        }
        catch (DalNotFoundException entity) {
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return this.convert(transactionReport);
    }

    public TransactionReport queryWeeklyReport(String domain, Date start) {
        TransactionReport transactionReport = new TransactionReport(domain);
        try {
            WeeklyReport entity = this.m_weeklyReportDao.findReportByDomainNamePeriod(start, domain, "transaction", WeeklyReportEntity.READSET_FULL);
            transactionReport = this.queryFromWeeklyBinary(entity.getId(), domain);
        }
        catch (DalNotFoundException entity) {
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return this.convert(transactionReport);
    }
}

