/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.transaction.task;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.transaction.TransactionReportCountFilter;
import com.dianping.cat.consumer.transaction.model.IVisitor;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.consumer.transaction.model.transform.DefaultNativeBuilder;
import com.dianping.cat.core.dal.DailyGraph;
import com.dianping.cat.core.dal.DailyGraphDao;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.Graph;
import com.dianping.cat.core.dal.GraphDao;
import com.dianping.cat.core.dal.MonthlyReport;
import com.dianping.cat.core.dal.WeeklyReport;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.report.page.transaction.service.TransactionReportService;
import com.dianping.cat.report.page.transaction.task.DailyTransactionGraphCreator;
import com.dianping.cat.report.page.transaction.task.HistoryTransactionReportMerger;
import com.dianping.cat.report.page.transaction.task.TransactionGraphCreator;
import com.dianping.cat.report.page.transaction.task.TransactionMerger;
import com.dianping.cat.report.task.TaskBuilder;
import com.dianping.cat.report.task.TaskHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.unidal.dal.jdbc.DalException;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionReportBuilder
implements TaskBuilder,
LogEnabled {
    public static final String ID = "transaction";
    @Inject
    protected GraphDao m_graphDao;
    @Inject
    protected DailyGraphDao m_dailyGraphDao;
    @Inject
    protected TransactionReportService m_reportService;
    @Inject
    private TransactionGraphCreator m_transactionGraphCreator;
    @Inject
    private TransactionMerger m_transactionMerger;
    private Logger m_logger;

    public boolean buildDailyTask(String name, String domain, Date period) {
        try {
            Date end = TaskHelper.tomorrowZero((Date)period);
            TransactionReport transactionReport = this.queryHourlyReportsByDuration(name, domain, period, end);
            this.buildDailyTransactionGraph(transactionReport);
            DailyReport report = new DailyReport();
            report.setCreationDate(new Date());
            report.setDomain(domain);
            report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
            report.setName(name);
            report.setPeriod(period);
            report.setType(1);
            byte[] binaryContent = DefaultNativeBuilder.build((TransactionReport)transactionReport);
            return this.m_reportService.insertDailyReport(report, binaryContent);
        }
        catch (Exception e) {
            this.m_logger.error(e.getMessage(), (Throwable)e);
            Cat.logError((Throwable)e);
            return false;
        }
    }

    private void buildDailyTransactionGraph(TransactionReport report) {
        DailyTransactionGraphCreator creator = new DailyTransactionGraphCreator();
        List graphs = creator.buildDailygraph(report);
        for (DailyGraph graph : graphs) {
            try {
                this.m_dailyGraphDao.insert(graph);
            }
            catch (DalException e) {
                Cat.logError((Throwable)e);
            }
        }
    }

    private List<Graph> buildHourlyGraphs(String name, String domain, Date period) throws DalException {
        long startTime = period.getTime();
        TransactionReport report = (TransactionReport)this.m_reportService.queryReport(domain, new Date(startTime), new Date(startTime + 3600000L));
        return this.m_transactionGraphCreator.splitReportToGraphs(period, domain, ID, report);
    }

    public boolean buildHourlyTask(String name, String domain, Date period) {
        try {
            List graphs = this.buildHourlyGraphs(name, domain, period);
            if (graphs != null) {
                for (Graph graph : graphs) {
                    this.m_graphDao.insert(graph);
                }
            }
        }
        catch (Exception e) {
            this.m_logger.error(e.getMessage(), (Throwable)e);
            Cat.logError((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        Date end = null;
        end = period.equals(TimeHelper.getCurrentMonth()) ? TimeHelper.getCurrentDay() : TaskHelper.nextMonthStart((Date)period);
        TransactionReport transactionReport = this.queryDailyReportsByDuration(domain, period, end);
        MonthlyReport report = new MonthlyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((TransactionReport)transactionReport);
        return this.m_reportService.insertMonthlyReport(report, binaryContent);
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        Date end = null;
        end = period.equals(TimeHelper.getCurrentWeek()) ? TimeHelper.getCurrentDay() : new Date(period.getTime() + 604800000L);
        TransactionReport transactionReport = this.queryDailyReportsByDuration(domain, period, end);
        WeeklyReport report = new WeeklyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((TransactionReport)transactionReport);
        return this.m_reportService.insertWeeklyReport(report, binaryContent);
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    private TransactionReport queryDailyReportsByDuration(String domain, Date start, Date end) {
        long endTime = end.getTime();
        double duration = (double)(end.getTime() - start.getTime()) * 1.0 / 8.64E7;
        HistoryTransactionReportMerger merger = new HistoryTransactionReportMerger(new TransactionReport(domain)).setDuration(duration);
        for (long startTime = start.getTime(); startTime < endTime; startTime += 86400000L) {
            try {
                TransactionReport reportModel = (TransactionReport)this.m_reportService.queryReport(domain, new Date(startTime), new Date(startTime + 86400000L));
                reportModel.accept((IVisitor)merger);
                continue;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        TransactionReport transactionReport = merger.getTransactionReport();
        transactionReport.setStartTime(start);
        transactionReport.setEndTime(end);
        new TransactionReportCountFilter().visitTransactionReport(transactionReport);
        return transactionReport;
    }

    private TransactionReport queryHourlyReportsByDuration(String name, String domain, Date start, Date endDate) throws DalException {
        long startTime;
        Set domainSet = this.m_reportService.queryAllDomainNames(start, endDate, ID);
        ArrayList<TransactionReport> reports = new ArrayList<TransactionReport>();
        long endTime = endDate.getTime();
        double duration = (double)(endTime - startTime) * 1.0 / 8.64E7;
        for (startTime = start.getTime(); startTime < endTime; startTime += 3600000L) {
            TransactionReport report = (TransactionReport)this.m_reportService.queryReport(domain, new Date(startTime), new Date(startTime + 3600000L));
            reports.add(report);
        }
        return this.m_transactionMerger.mergeForDaily(domain, reports, domainSet, duration);
    }
}

