/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.web;

import com.dianping.cat.Cat;
import com.dianping.cat.helper.JsonBuilder;
import com.dianping.cat.report.page.web.CityManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.helper.Files;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CityManager
implements Initializable {
    public Map<String, List<City>> m_cities = new LinkedHashMap();

    public Map<String, List<City>> getCities() {
        return this.m_cities;
    }

    public String getCityInfo() {
        return new JsonBuilder().toJson((Object)this.m_cities);
    }

    public void initialize() throws InitializationException {
        try {
            this.loadChinaCities();
            this.loadForeignCities();
        }
        catch (IOException e) {
            Cat.logError((Throwable)e);
        }
    }

    private void loadChinaCities() throws IOException {
        String[] cities;
        String content = Files.forIO().readFrom(this.getClass().getResourceAsStream("/config/city"), "utf-8");
        for (String temp : cities = content.split("\n")) {
            String[] tabs = temp.split("\\|");
            if (tabs.length <= 3) continue;
            String province = tabs[1];
            String city = tabs[2];
            ArrayList<City> list = (ArrayList<City>)this.m_cities.get(province);
            if (list == null) {
                list = new ArrayList<City>();
                if (province.length() > 0) {
                    list.add(new City(this, province, ""));
                }
                this.m_cities.put(province, list);
            }
            list.add(new City(this, province, city));
        }
    }

    private void loadForeignCities() throws IOException {
        String[] foreignCities;
        String foreginContent = Files.forIO().readFrom(this.getClass().getResourceAsStream("/config/city_foreign"), "utf-8");
        for (String city : foreignCities = foreginContent.split("\n")) {
            String province = city;
            ArrayList<City> list = (ArrayList<City>)this.m_cities.get(province);
            if (list == null) {
                list = new ArrayList<City>();
                if (province.length() > 0) {
                    list.add(new City(this, province, ""));
                }
                this.m_cities.put(province, list);
            }
            list.add(new City(this, province, city));
        }
        String foreign = "\u56fd\u5916\u5176\u4ed6";
        ArrayList<City> foreigns = (ArrayList<City>)this.m_cities.get(foreign);
        if (foreigns == null) {
            foreigns = new ArrayList<City>();
            foreigns.add(new City(this, foreign, ""));
            foreigns.add(new City(this, foreign, foreign));
            this.m_cities.put(foreign, foreigns);
        }
    }
}

