/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.web;

import com.dianping.cat.Cat;
import com.dianping.cat.config.app.AppConfigManager;
import com.dianping.cat.config.web.url.UrlPatternConfigManager;
import com.dianping.cat.configuration.web.url.entity.PatternItem;
import com.dianping.cat.consumer.problem.model.entity.ProblemReport;
import com.dianping.cat.mvc.AbstractReportModel;
import com.dianping.cat.mvc.AbstractReportPayload;
import com.dianping.cat.mvc.PayloadNormalizer;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.graph.LineChart;
import com.dianping.cat.report.graph.PieChart;
import com.dianping.cat.report.page.app.display.ChartSorter;
import com.dianping.cat.report.page.app.display.PieChartDetailInfo;
import com.dianping.cat.report.page.problem.transform.ProblemStatistics;
import com.dianping.cat.report.page.web.Action;
import com.dianping.cat.report.page.web.CityManager;
import com.dianping.cat.report.page.web.Context;
import com.dianping.cat.report.page.web.Handler;
import com.dianping.cat.report.page.web.JspViewer;
import com.dianping.cat.report.page.web.Model;
import com.dianping.cat.report.page.web.Payload;
import com.dianping.cat.report.page.web.graph.WebGraphCreator;
import com.dianping.cat.report.page.web.service.WebApiQueryEntity;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.tuple.Pair;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Handler
implements PageHandler<Context> {
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private UrlPatternConfigManager m_patternManager;
    @Inject
    private AppConfigManager m_appConfigManager;
    @Inject
    private CityManager m_cityManager;
    @Inject
    private PayloadNormalizer m_normalizePayload;
    @Inject
    private WebGraphCreator m_graphCreator;
    @Inject(type=ModelService.class, value={"problem"})
    private ModelService<ProblemReport> m_service;

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="web")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    private LineChart buildLineChart(Payload payload) {
        WebApiQueryEntity entity1 = payload.getQueryEntity1();
        WebApiQueryEntity entity2 = payload.getQueryEntity2();
        String type = payload.getType();
        LineChart lineChart = new LineChart();
        try {
            lineChart = this.m_graphCreator.buildLineChart(entity1, entity2, type);
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return lineChart;
    }

    private Pair<PieChart, List<PieChartDetailInfo>> buildPieChart(Payload payload) {
        try {
            Pair pair = this.m_graphCreator.buildPieChart(payload.getQueryEntity1(), payload.getGroupByField());
            List infos = (List)pair.getValue();
            Collections.sort(infos, new ChartSorter().buildPieChartInfoComparator());
            return pair;
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return null;
        }
    }

    @OutboundActionMeta(name="web")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        Action action = payload.getAction();
        this.normalize(model, payload);
        switch (1.$SwitchMap$com$dianping$cat$report$page$web$Action[action.ordinal()]) {
            case 1: {
                LineChart lineChart = this.buildLineChart(payload);
                model.setLineChart(lineChart);
                break;
            }
            case 2: {
                Pair pieChartPair = this.buildPieChart(payload);
                if (pieChartPair == null) break;
                model.setPieChart((PieChart)pieChartPair.getKey());
                model.setPieChartDetailInfos((List)pieChartPair.getValue());
                break;
            }
            case 3: {
                try {
                    LineChart lineChart = this.buildLineChart(payload);
                    model.setJson(lineChart.toString());
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
                break;
            }
            case 4: {
                ProblemReport problemReport = this.getHourlyReport(payload);
                ProblemStatistics problemStatistics = new ProblemStatistics();
                String ip = payload.getIpAddress();
                if (ip.equals("All")) {
                    problemStatistics.setAllIp(true);
                } else {
                    problemStatistics.setIp(ip);
                }
                problemStatistics.visitProblemReport(problemReport);
                model.setProblemReport(problemReport);
                model.setAllStatistics(problemStatistics);
            }
        }
        if (!ctx.isProcessStopped()) {
            this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
        }
    }

    private ProblemReport getHourlyReport(Payload payload) {
        ModelRequest request = new ModelRequest("FrontEnd", payload.getDate()).setProperty("queryType", "view");
        if (!"All".equals(payload.getIpAddress())) {
            request.setProperty("ip", payload.getIpAddress());
        }
        if (!StringUtils.isEmpty((String)payload.getType())) {
            request.setProperty("type", "error");
        }
        if (this.m_service.isEligable(request)) {
            ModelResponse response = this.m_service.invoke(request);
            ProblemReport report = (ProblemReport)response.getModel();
            return report;
        }
        throw new RuntimeException("Internal error: no eligible problem service registered for " + request + "!");
    }

    private void normalize(Model model, Payload payload) {
        model.setAction((org.unidal.web.mvc.Action)payload.getAction());
        model.setPage((Page)ReportPage.WEB);
        model.setCities(this.m_appConfigManager.queryConfigItem("\u57ce\u5e02"));
        model.setOperators(this.m_appConfigManager.queryConfigItem("\u8fd0\u8425\u5546"));
        model.setCodes(this.m_patternManager.queryCodes());
        PatternItem first = (PatternItem)this.m_patternManager.queryUrlPatternRules().iterator().next();
        model.setDefaultApi(first.getName() + "|" + first.getPattern());
        model.setPattermItems(this.m_patternManager.queryUrlPatterns());
        this.m_normalizePayload.normalize((AbstractReportModel)model, (AbstractReportPayload)payload);
    }
}

