/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.web;

import com.dianping.cat.Cat;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.mvc.AbstractReportPayload;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.page.web.Action;
import com.dianping.cat.report.page.web.service.WebApiField;
import com.dianping.cat.report.page.web.service.WebApiQueryEntity;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.unidal.tuple.Pair;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.payload.annotation.FieldMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Payload
extends AbstractReportPayload<Action, ReportPage> {
    private ReportPage m_page;
    @FieldMeta(value="op")
    private Action m_action;
    @FieldMeta(value="url")
    private String m_url;
    @FieldMeta(value="type")
    private String m_type = "request";
    @FieldMeta(value="query1")
    private String m_query1;
    @FieldMeta(value="query2")
    private String m_query2;
    @FieldMeta(value="api1")
    private String m_api1;
    @FieldMeta(value="api2")
    private String m_api2;
    @FieldMeta(value="groupByField")
    private WebApiField m_groupByField = WebApiField.CODE;
    private SimpleDateFormat m_format = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public Payload() {
        super((Page)ReportPage.WEB);
    }

    private Date generateDate(String time, long start) {
        Date date = null;
        String[] times = time.split(":");
        if (times.length == 2) {
            int hour = Integer.parseInt(times[0]);
            int minute = Integer.parseInt(times[1]);
            if (minute > 0) {
                ++hour;
            }
            if ((date = new Date(TimeHelper.getCurrentDay((long)start).getTime() + (long)hour * 3600000L)).equals(TimeHelper.getCurrentDay((long)start, (int)1))) {
                date = new Date(date.getTime() - 60000L);
            }
        } else {
            date = TimeHelper.getCurrentHour((int)1);
        }
        return date;
    }

    private Date generateDefaultEnd() {
        Date date = TimeHelper.getCurrentHour((int)1);
        if (date.equals(TimeHelper.getCurrentDay((long)System.currentTimeMillis(), (int)1))) {
            date = new Date(date.getTime() - 60000L);
        }
        return date;
    }

    public Action getAction() {
        return this.m_action;
    }

    public String getApi1() {
        return this.m_api1;
    }

    public String getApi2() {
        return this.m_api2;
    }

    public WebApiField getGroupByField() {
        return this.m_groupByField;
    }

    public Pair<Date, Date> getHistoryEndDatePair() {
        Date currentEnd = this.generateDefaultEnd();
        Date compareEnd = null;
        try {
            if (this.m_customEnd != null && this.m_customEnd.length() > 0) {
                String[] ends = this.m_customEnd.split(";");
                Pair startDatePair = this.getHistoryStartDatePair();
                long start = ((Date)startDatePair.getKey()).getTime();
                currentEnd = this.generateDate(ends[0], start);
                if (ends.length == 2) {
                    start = ((Date)startDatePair.getValue()).getTime();
                    compareEnd = this.generateDate(ends[1], start);
                }
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return new Pair((Object)currentEnd, compareEnd);
    }

    public Pair<Date, Date> getHistoryStartDatePair() {
        Date currentStart = TimeHelper.getCurrentDay();
        Date compareStart = null;
        try {
            if (this.m_customStart != null && this.m_customStart.length() > 0) {
                String[] starts = this.m_customStart.split(";");
                Date current = this.m_format.parse(starts[0]);
                currentStart = new Date(current.getTime() - current.getTime() % 3600000L);
                if (starts.length == 2) {
                    Date compare = this.m_format.parse(starts[1]);
                    compareStart = new Date(compare.getTime() - compare.getTime() % 3600000L);
                }
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return new Pair((Object)currentStart, compareStart);
    }

    public ReportPage getPage() {
        return this.m_page;
    }

    public String getQuery1() {
        return this.m_query1;
    }

    public String getQuery2() {
        return this.m_query2;
    }

    public WebApiQueryEntity getQueryEntity1() {
        if (this.m_query1 != null && this.m_query1.length() > 0) {
            return new WebApiQueryEntity(this.m_query1);
        }
        return new WebApiQueryEntity();
    }

    public WebApiQueryEntity getQueryEntity2() {
        if (this.m_query2 != null && this.m_query2.length() > 0) {
            return new WebApiQueryEntity(this.m_query2);
        }
        return null;
    }

    public String getType() {
        return this.m_type;
    }

    public String getUrl() {
        return this.m_url;
    }

    public void setAction(String action) {
        this.m_action = Action.getByName((String)action, (Action)Action.VIEW);
    }

    public void setGroupByField(String groupByField) {
        this.m_groupByField = WebApiField.getByName((String)groupByField, (WebApiField)WebApiField.CODE);
    }

    public void setPage(String page) {
        this.m_page = ReportPage.getByName((String)page, (ReportPage)ReportPage.WEB);
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public void setUrl(String url) {
        this.m_url = url;
    }

    public void validate(ActionContext<?> ctx) {
        if (this.m_action == null) {
            this.m_action = Action.VIEW;
        }
    }
}

