/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.web.graph;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.metric.model.entity.MetricItem;
import com.dianping.cat.consumer.metric.model.entity.MetricReport;
import com.dianping.cat.consumer.metric.model.entity.Segment;
import com.dianping.cat.consumer.metric.model.entity.StatisticsItem;
import com.dianping.cat.consumer.metric.model.transform.BaseVisitor;
import org.unidal.lookup.util.StringUtils;

public class WebReportConvertor
extends BaseVisitor {
    private MetricReport m_report;
    private String m_type;
    private String m_city;
    private String m_channel;

    public WebReportConvertor(String type, String city, String channel) {
        this.m_type = type;
        this.m_city = city;
        this.m_channel = channel;
    }

    private void buildDetailInfo(MetricItem metricItem, String city, String channel, String info) {
        int total = 0;
        for (Segment segment : metricItem.getSegments().values()) {
            total += segment.getCount();
        }
        if ("info".equals(this.m_type)) {
            StatisticsItem tem;
            String key = "";
            if (info.equals("hit")) {
                key = "\u8bbf\u95ee\u91cf\u5206\u5e03";
            } else if (info.equals("error")) {
                key = "\u9519\u8bef\u91cf\u5206\u5e03";
            } else {
                return;
            }
            int index = city.indexOf(45);
            if (StringUtils.isEmpty((String)this.m_city)) {
                tem = this.m_report.findOrCreateStatistic("\u6309\u57ce\u5e02" + key).findOrCreateStatisticsItem(city.substring(0, index));
                tem.setCount(tem.getCount() + total);
            } else if (!this.m_city.equals(city)) {
                tem = this.m_report.findOrCreateStatistic("\u6309\u57ce\u5e02" + key).findOrCreateStatisticsItem(city.substring(index + 1));
                tem.setCount(tem.getCount() + total);
            }
            if (StringUtils.isEmpty((String)this.m_channel)) {
                tem = this.m_report.findOrCreateStatistic("\u6309\u8fd0\u8425\u5546" + key).findOrCreateStatisticsItem(channel);
                tem.setCount(tem.getCount() + total);
            }
        }
    }

    public MetricReport getReport() {
        return this.m_report;
    }

    public void mergeMetricItem(MetricItem from, MetricItem to) {
        for (Segment temp : to.getSegments().values()) {
            Segment target = from.findOrCreateSegment(temp.getId());
            this.mergeSegment(target, temp);
        }
    }

    protected void mergeSegment(Segment old, Segment point) {
        old.setCount(old.getCount() + point.getCount());
        old.setSum(old.getSum() + point.getSum());
        if (old.getCount() > 0) {
            old.setAvg(old.getSum() / (double)old.getCount());
        }
    }

    private boolean validate(String city, String channel, String info) {
        return "info".equals(this.m_type) ? this.validateCity(city) && this.validateChannel(channel) && this.validateInfo(info) : ("httpStatus".equals(this.m_type) ? this.validateCity(city) && this.validateChannel(channel) && this.validateHttpStatus(info) : "errorCode".equals(this.m_type) && this.validateCity(city) && this.validateChannel(channel) && this.validateErrorCode(info));
    }

    private boolean validateChannel(String channel) {
        return StringUtils.isEmpty((String)this.m_channel) || channel.equals(this.m_channel);
    }

    private boolean validateCity(String city) {
        return StringUtils.isEmpty((String)this.m_city) || city.contains(this.m_city);
    }

    private boolean validateErrorCode(String info) {
        return info.startsWith("errorCode");
    }

    private boolean validateHttpStatus(String info) {
        return info.startsWith("httpStatus");
    }

    private boolean validateInfo(String info) {
        return "avg".equals(info) || "hit".equals(info) || "error".equals(info);
    }

    public void visitMetricItem(MetricItem metricItem) {
        try {
            String id = metricItem.getId();
            String[] temp = id.split(":");
            String city = temp[2];
            String channel = temp[3];
            String info = temp[4];
            if (this.validate(city, channel, info)) {
                MetricItem item = this.m_report.findOrCreateMetricItem(info);
                this.mergeMetricItem(item, metricItem);
                this.buildDetailInfo(metricItem, city, channel, info);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }

    public void visitMetricReport(MetricReport metricReport) {
        this.m_report = new MetricReport(metricReport.getProduct());
        this.m_report.setStartTime(metricReport.getStartTime());
        this.m_report.setEndTime(metricReport.getEndTime());
        super.visitMetricReport(metricReport);
    }

    public void visitSegment(Segment segment) {
        super.visitSegment(segment);
    }
}

