/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.web.service;

import com.dianping.cat.Cat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.unidal.helper.Splitters;
import org.unidal.lookup.util.StringUtils;

public class WebApiQueryEntity {
    public static final int DEFAULT_COMMAND = 1;
    protected Date m_date;
    public static final int DEFAULT_VALUE = -1;
    protected int m_id;
    protected int m_city = -1;
    protected int m_operator = -1;
    private int m_code = -1;
    private int m_startMinuteOrder = -1;
    private int m_endMinuteOrder = -1;

    public WebApiQueryEntity() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.m_date = cal.getTime();
        this.m_id = 1;
    }

    public WebApiQueryEntity(String query) {
        List strs = Splitters.by((String)";").split(query);
        try {
            this.m_date = this.parseDate((String)strs.get(0));
            this.m_id = this.parseValue((String)strs.get(1));
            this.m_code = this.parseValue((String)strs.get(2));
            this.m_city = this.parseValue((String)strs.get(3));
            this.m_operator = this.parseValue((String)strs.get(4));
            this.m_startMinuteOrder = this.convert2MinuteOrder((String)strs.get(5));
            this.m_endMinuteOrder = this.convert2MinuteOrder((String)strs.get(6));
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }

    protected int convert2MinuteOrder(String time) {
        int current = -1;
        if (StringUtils.isNotEmpty((String)time)) {
            try {
                current = Integer.parseInt(time);
            }
            catch (NumberFormatException e) {
                String[] pair = time.split(":");
                int hour = Integer.parseInt(pair[0]);
                int minute = Integer.parseInt(pair[1]);
                current = hour * 60 + minute;
                current -= current % 5;
            }
        }
        return current;
    }

    public int getCity() {
        return this.m_city;
    }

    public int getCode() {
        return this.m_code;
    }

    public Date getDate() {
        return this.m_date;
    }

    public int getEndMinuteOrder() {
        return this.m_endMinuteOrder;
    }

    public int getId() {
        return this.m_id;
    }

    public int getOperator() {
        return this.m_operator;
    }

    public int getStartMinuteOrder() {
        return this.m_startMinuteOrder;
    }

    protected Date parseDate(String dateStr) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (StringUtils.isNotEmpty((String)dateStr)) {
            return sdf.parse(dateStr);
        }
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    protected int parseValue(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return -1;
        }
        return Integer.parseInt(str);
    }

    public void setCity(int city) {
        this.m_city = city;
    }

    public void setCode(int code) {
        this.m_code = code;
    }

    public void setDate(Date date) {
        this.m_date = date;
    }

    public void setEndMinuteOrder(int endMinuteOrder) {
        this.m_endMinuteOrder = endMinuteOrder;
    }

    public void setId(int id) {
        this.m_id = id;
    }

    public void setOperator(int operator) {
        this.m_operator = operator;
    }

    public void setStartMinuteOrder(int startMinuteOrder) {
        this.m_startMinuteOrder = startMinuteOrder;
    }
}

