/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.web.service;

import com.dianping.cat.Cat;
import com.dianping.cat.app.WebApiData;
import com.dianping.cat.app.WebApiDataDao;
import com.dianping.cat.app.WebApiDataEntity;
import com.dianping.cat.config.web.url.UrlPatternConfigManager;
import com.dianping.cat.report.page.app.display.AppDataSequence;
import com.dianping.cat.report.page.web.service.WebApiField;
import com.dianping.cat.report.page.web.service.WebApiQueryEntity;
import com.dianping.cat.report.page.web.service.WebApiService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebApiService {
    @Inject
    private WebApiDataDao m_dao;
    @Inject
    private UrlPatternConfigManager m_urlConfigManager;
    public static final String SUCCESS = "success";
    public static final String REQUEST = "request";
    public static final String DELAY = "delay";

    private AppDataSequence<WebApiData> buildAppSequence(List<WebApiData> fromDatas, Date period) {
        LinkedHashMap<Integer, LinkedList<WebApiData>> dataMap = new LinkedHashMap<Integer, LinkedList<WebApiData>>();
        int max = -5;
        for (WebApiData from : fromDatas) {
            LinkedList<WebApiData> data;
            int minute = from.getMinuteOrder();
            if (max < 0 || max < minute) {
                max = minute;
            }
            if ((data = (LinkedList<WebApiData>)dataMap.get(minute)) == null) {
                data = new LinkedList<WebApiData>();
                dataMap.put(minute, data);
            }
            data.add(from);
        }
        int n = max / 5 + 1;
        int length = this.queryAppDataDuration(period, n);
        return new AppDataSequence(length, dataMap);
    }

    public Double[] computeDelayAvg(AppDataSequence<WebApiData> convertedData) {
        int n = convertedData.getDuration();
        Double[] value = new Double[n];
        for (Map.Entry entry : convertedData.getRecords().entrySet()) {
            for (WebApiData data : (List)entry.getValue()) {
                long count = data.getAccessNumberSum();
                long sum = data.getResponseSumTimeSum();
                double avg = sum / count;
                int index = data.getMinuteOrder() / 5;
                if (index >= n) continue;
                value[index] = avg;
            }
        }
        return value;
    }

    public Double[] computeRequestCount(AppDataSequence<WebApiData> convertedData) {
        int n = convertedData.getDuration();
        Double[] value = new Double[n];
        for (Map.Entry entry : convertedData.getRecords().entrySet()) {
            for (WebApiData data : (List)entry.getValue()) {
                double count = data.getAccessNumberSum();
                int index = data.getMinuteOrder() / 5;
                if (index >= n) continue;
                value[index] = count;
            }
        }
        return value;
    }

    public Double[] computeSuccessRatio(int commandId, AppDataSequence<WebApiData> convertedData) {
        int n = convertedData.getDuration();
        Double[] value = new Double[n];
        for (int i = 0; i < n; ++i) {
            value[i] = 100.0;
        }
        try {
            for (Map.Entry entry : convertedData.getRecords().entrySet()) {
                int key = (Integer)entry.getKey();
                int index = key / 5;
                if (index >= n) continue;
                value[index] = this.computeSuccessRatio(commandId, (List)entry.getValue());
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return value;
    }

    private double computeSuccessRatio(int commandId, List<WebApiData> datas) {
        long success = 0L;
        long sum = 0L;
        for (WebApiData data : datas) {
            long number = data.getAccessNumberSum();
            if (this.m_urlConfigManager.isSuccessCode(data.getCode())) {
                success += number;
            }
            sum += number;
        }
        return sum == 0L ? 0.0 : (double)success / (double)sum * 100.0;
    }

    private int queryAppDataDuration(Date period, int defaultValue) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (period.equals(cal.getTime())) {
            long start = cal.getTimeInMillis();
            long current = System.currentTimeMillis();
            int length = (int)(current - current % 300000L - start) / 300000 - 1;
            return length < 0 ? 0 : length;
        }
        return defaultValue;
    }

    public List<WebApiData> queryByField(WebApiQueryEntity entity, WebApiField groupByField) {
        List<Object> datas = new ArrayList<WebApiData>();
        int apiId = entity.getId();
        Date period = entity.getDate();
        int city = entity.getCity();
        int operator = entity.getOperator();
        int code = entity.getCode();
        int startMinuteOrder = entity.getStartMinuteOrder();
        int endMinuteOrder = entity.getEndMinuteOrder();
        try {
            switch (1.$SwitchMap$com$dianping$cat$report$page$web$service$WebApiField[groupByField.ordinal()]) {
                case 1: {
                    datas = this.m_dao.findDataByOperator(apiId, period, city, operator, code, startMinuteOrder, endMinuteOrder, WebApiDataEntity.READSET_OPERATOR_DATA);
                    break;
                }
                case 2: {
                    datas = this.m_dao.findDataByCity(apiId, period, city, operator, code, startMinuteOrder, endMinuteOrder, WebApiDataEntity.READSET_CITY_DATA);
                    break;
                }
                case 3: {
                    datas = this.m_dao.findDataByCode(apiId, period, city, operator, code, startMinuteOrder, endMinuteOrder, WebApiDataEntity.READSET_CODE_DATA);
                }
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return datas;
    }

    public double queryOneDayDelayAvg(WebApiQueryEntity entity) {
        Double[] values = this.queryValue(entity, DELAY);
        double delaySum = 0.0;
        int size = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            delaySum += values[i].doubleValue();
            ++size;
        }
        return size > 0 ? delaySum / (double)size : -1.0;
    }

    public Double[] queryValue(WebApiQueryEntity entity, String type) {
        int apiId = entity.getId();
        Date period = entity.getDate();
        int city = entity.getCity();
        int operator = entity.getOperator();
        int code = entity.getCode();
        List datas = new ArrayList();
        try {
            if (SUCCESS.equals(type)) {
                datas = this.m_dao.findDataByMinuteCode(apiId, period, city, operator, code, WebApiDataEntity.READSET_SUCCESS_DATA);
                AppDataSequence s = this.buildAppSequence(datas, entity.getDate());
                return this.computeSuccessRatio(apiId, s);
            }
            if (REQUEST.equals(type)) {
                datas = this.m_dao.findDataByMinute(apiId, period, city, operator, code, WebApiDataEntity.READSET_COUNT_DATA);
                AppDataSequence s = this.buildAppSequence(datas, entity.getDate());
                return this.computeRequestCount(s);
            }
            if (DELAY.equals(type)) {
                datas = this.m_dao.findDataByMinute(apiId, period, city, operator, code, WebApiDataEntity.READSET_AVG_DATA);
                AppDataSequence s = this.buildAppSequence(datas, entity.getDate());
                return this.computeDelayAvg(s);
            }
            throw new RuntimeException("unexpected query type, type:" + type);
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return null;
        }
    }
}

