/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task;

import com.dianping.cat.Cat;
import com.dianping.cat.core.dal.Task;
import com.dianping.cat.report.task.TaskBuilder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.lookup.ContainerHolder;

public class ReportFacade
extends ContainerHolder
implements LogEnabled,
Initializable {
    private Logger m_logger;
    private Map<String, TaskBuilder> m_reportBuilders = new HashMap();

    public boolean builderReport(Task task) {
        try {
            if (task == null) {
                return false;
            }
            int type = task.getTaskType();
            String reportName = task.getReportName();
            String reportDomain = task.getReportDomain();
            Date reportPeriod = task.getReportPeriod();
            TaskBuilder reportBuilder = this.getReportBuilder(reportName);
            if (reportBuilder == null) {
                Cat.logError((Throwable)new RuntimeException("no report builder for type: " + reportName));
                return false;
            }
            boolean result = false;
            if (type == 0) {
                result = reportBuilder.buildHourlyTask(reportName, reportDomain, reportPeriod);
            } else if (type == 1) {
                result = reportBuilder.buildDailyTask(reportName, reportDomain, reportPeriod);
            } else if (type == 2) {
                result = reportBuilder.buildWeeklyTask(reportName, reportDomain, reportPeriod);
            } else if (type == 3) {
                result = reportBuilder.buildMonthlyTask(reportName, reportDomain, reportPeriod);
            }
            if (result) {
                return result;
            }
            this.m_logger.error(task.toString());
        }
        catch (Exception e) {
            this.m_logger.error("Error when building report," + e.getMessage(), (Throwable)e);
            Cat.logError((Throwable)e);
            return false;
        }
        return false;
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    private TaskBuilder getReportBuilder(String reportName) {
        return (TaskBuilder)this.m_reportBuilders.get(reportName);
    }

    public void initialize() throws InitializationException {
        this.m_reportBuilders = this.lookupMap(TaskBuilder.class);
    }
}

