/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task.cached;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerFilterConfigManager;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.report.page.cross.task.CrossReportBuilder;
import com.dianping.cat.report.page.event.task.EventReportBuilder;
import com.dianping.cat.report.page.matrix.task.MatrixReportBuilder;
import com.dianping.cat.report.page.problem.task.ProblemReportBuilder;
import com.dianping.cat.report.page.transaction.service.TransactionReportService;
import com.dianping.cat.report.page.transaction.task.TransactionReportBuilder;
import java.util.Date;
import java.util.Set;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;

public class CachedReportTask
implements Threads.Task {
    @Inject
    private TransactionReportService m_transactionReportService;
    @Inject
    private ServerFilterConfigManager m_serverFilterConfigManager;
    @Inject
    private TransactionReportBuilder m_transactionReportBuilder;
    @Inject
    private EventReportBuilder m_eventReportBuilder;
    @Inject
    private ProblemReportBuilder m_problemReportBuilder;
    @Inject
    private CrossReportBuilder m_crossReportBuilder;
    @Inject
    private MatrixReportBuilder m_matrixReportBuilder;

    public String getName() {
        return "Cached-Report-Task";
    }

    private void reloadCurrentMonthly() {
        Date start = TimeHelper.getCurrentMonth();
        Date end = TimeHelper.getCurrentDay();
        Set domains = this.m_transactionReportService.queryAllDomainNames(start, end, "transaction");
        for (String domain : domains) {
            if (!this.m_serverFilterConfigManager.validateDomain(domain)) continue;
            Transaction t = Cat.newTransaction((String)"ReloadTask", (String)("Reload-Month-" + domain));
            this.m_transactionReportBuilder.buildMonthlyTask("transaction", domain, start);
            this.m_eventReportBuilder.buildMonthlyTask("event", domain, start);
            this.m_problemReportBuilder.buildMonthlyTask("problem", domain, start);
            this.m_crossReportBuilder.buildMonthlyTask("cross", domain, start);
            this.m_matrixReportBuilder.buildMonthlyTask("matrix", domain, start);
            t.setStatus("0");
            t.complete();
        }
    }

    private void reloadCurrentWeekly() {
        Date start = TimeHelper.getCurrentWeek();
        Date end = TimeHelper.getCurrentDay();
        Set domains = this.m_transactionReportService.queryAllDomainNames(start, end, "transaction");
        for (String domain : domains) {
            if (!this.m_serverFilterConfigManager.validateDomain(domain)) continue;
            Transaction t = Cat.newTransaction((String)"ReloadTask", (String)("Reload-Week-" + domain));
            this.m_transactionReportBuilder.buildWeeklyTask("transaction", domain, start);
            this.m_eventReportBuilder.buildWeeklyTask("event", domain, start);
            this.m_problemReportBuilder.buildWeeklyTask("problem", domain, start);
            this.m_crossReportBuilder.buildWeeklyTask("cross", domain, start);
            this.m_matrixReportBuilder.buildWeeklyTask("matrix", domain, start);
            t.setStatus("0");
            t.complete();
        }
    }

    public void run() {
        this.reloadCurrentWeekly();
        this.reloadCurrentMonthly();
    }

    public void shutdown() {
    }
}

