/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task.notify;

import com.dianping.cat.Cat;
import com.dianping.cat.config.app.AppComparisonConfigManager;
import com.dianping.cat.config.app.AppConfigManager;
import com.dianping.cat.configuration.app.comparison.entity.AppComparison;
import com.dianping.cat.configuration.app.comparison.entity.AppComparisonConfig;
import com.dianping.cat.configuration.app.comparison.entity.Item;
import com.dianping.cat.configuration.app.entity.Command;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.report.alert.sender.AlertChannel;
import com.dianping.cat.report.alert.sender.AlertMessageEntity;
import com.dianping.cat.report.alert.sender.sender.SenderManager;
import com.dianping.cat.report.page.app.service.AppDataService;
import com.dianping.cat.report.page.app.service.CommandQueryEntity;
import com.dianping.cat.report.task.notify.AppDataComparisonResult;
import com.dianping.cat.report.task.notify.render.AppDataComparisonRender;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unidal.helper.Splitters;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppDataComparisonNotifier {
    @Inject
    private AppDataService m_appDataService;
    @Inject
    private AppComparisonConfigManager m_appComparisonConfigManager;
    @Inject
    private AppConfigManager m_appConfigManager;
    @Inject
    private SenderManager m_sendManager;
    @Inject
    private AppDataComparisonRender m_render;
    private SimpleDateFormat m_sdf = new SimpleDateFormat("yyyy-MM-dd");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doNotifying(Date period) {
        Transaction t = Cat.newTransaction((String)"AppDataComparitonNotifier", (String)this.m_sdf.format(period));
        try {
            Map results = this.buildAppDataComparisonResults(period, this.m_appComparisonConfigManager.getConfig());
            Map results2Receivers = this.buildReceivers2Results(results);
            for (Map.Entry entry : results2Receivers.entrySet()) {
                this.notify(period, (List)entry.getValue(), (List)entry.getKey());
            }
            t.setStatus("0");
        }
        catch (Exception e) {
            t.setStatus((Throwable)e);
        }
        finally {
            t.complete();
        }
    }

    private Set<String> buildAllUsers(Map<String, AppDataComparisonResult> results) {
        HashSet<String> allUsers = new HashSet<String>();
        for (Map.Entry<String, AppDataComparisonResult> entry : results.entrySet()) {
            AppDataComparisonResult result = entry.getValue();
            String id = result.getId();
            allUsers.addAll(this.m_appComparisonConfigManager.queryEmails(id));
        }
        return allUsers;
    }

    private Map<String, String> buildUser2Ids(Set<String> allUsers, Map<String, AppDataComparisonResult> results) {
        HashMap<String, String> user2Id = new HashMap<String, String>();
        for (String user : allUsers) {
            for (Map.Entry<String, AppDataComparisonResult> entry : results.entrySet()) {
                AppDataComparisonResult result = entry.getValue();
                String id = result.getId();
                String emails = this.m_appComparisonConfigManager.queryEmailStr(id);
                if (!emails.contains(user)) continue;
                String ids = (String)user2Id.get(user);
                if (StringUtils.isEmpty((String)ids)) {
                    user2Id.put(user, id);
                    continue;
                }
                user2Id.put(user, ids + "," + id);
            }
        }
        return user2Id;
    }

    private Map<String, String> buildid2Users(Map<String, String> user2Id) {
        HashMap<String, String> id2Users = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : user2Id.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String users = user2Id.get(value);
            if (StringUtils.isEmpty((String)users)) {
                id2Users.put(value, key);
                continue;
            }
            id2Users.put(value, users + "," + value);
        }
        return id2Users;
    }

    private Map<List<String>, List<AppDataComparisonResult>> buildReceivers2Results(Map<String, AppDataComparisonResult> results) {
        Set allUsers = this.buildAllUsers(results);
        Map user2Ids = this.buildUser2Ids(allUsers, results);
        Map id2Users = this.buildid2Users(user2Ids);
        Map users2Results = this.buildUsers2Results(id2Users, results);
        return users2Results;
    }

    private Map<List<String>, List<AppDataComparisonResult>> buildUsers2Results(Map<String, String> id2Users, Map<String, AppDataComparisonResult> results) {
        HashMap<List<String>, List<AppDataComparisonResult>> users2Results = new HashMap<List<String>, List<AppDataComparisonResult>>();
        for (Map.Entry<String, String> entry : id2Users.entrySet()) {
            List emails = Splitters.by((String)",").noEmptyItem().split(entry.getValue());
            List ids = Splitters.by((String)",").noEmptyItem().split(entry.getKey());
            ArrayList<AppDataComparisonResult> userResults = new ArrayList<AppDataComparisonResult>();
            for (String id : ids) {
                userResults.add(results.get(id));
            }
            users2Results.put(emails, userResults);
        }
        return users2Results;
    }

    private void notify(Date yesterday, List<AppDataComparisonResult> results, List<String> emails) {
        String title = this.renderTitle();
        String content = this.m_render.renderReport(yesterday, results);
        AlertMessageEntity message = new AlertMessageEntity("", title, "AppDataComparison", content, emails);
        this.m_sendManager.sendAlert(AlertChannel.MAIL, message);
    }

    private String renderTitle() {
        return "CAT\u7aef\u5230\u7aef\u62a5\u544a";
    }

    private Map<String, AppDataComparisonResult> buildAppDataComparisonResults(Date date, AppComparisonConfig config) {
        LinkedHashMap<String, AppDataComparisonResult> results = new LinkedHashMap<String, AppDataComparisonResult>();
        for (Map.Entry entry : config.getAppComparisons().entrySet()) {
            AppDataComparisonResult result = this.queryDelay4AppComparison(date, (AppComparison)entry.getValue());
            results.put((String)entry.getKey(), result);
        }
        return results;
    }

    private AppDataComparisonResult queryDelay4AppComparison(Date yesterday, AppComparison appComparison) {
        String id = appComparison.getId();
        AppDataComparisonResult result = new AppDataComparisonResult();
        result.setId(id);
        for (Item item : appComparison.getItems()) {
            try {
                String itemId = item.getId();
                String command = item.getCommand();
                double delay = this.queryOneDayDelay4Command(yesterday, command);
                result.addItem(itemId, command, delay);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        return result;
    }

    private double queryOneDayDelay4Command(Date yesterday, String url) {
        String yesterdayStr = this.m_sdf.format(yesterday);
        Command command = (Command)this.m_appConfigManager.getCommands().get(url);
        if (command != null) {
            CommandQueryEntity entity = new CommandQueryEntity(yesterdayStr + ";" + command + ";;;;;;;;;");
            return this.m_appDataService.queryOneDayDelayAvg(entity);
        }
        throw new RuntimeException("Unrecognized command configuration in app comparison config, command id: " + url);
    }
}

