/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task.notify;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerFilterConfigManager;
import com.dianping.cat.consumer.event.model.entity.EventReport;
import com.dianping.cat.consumer.problem.model.entity.ProblemReport;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.report.alert.sender.AlertChannel;
import com.dianping.cat.report.alert.sender.AlertMessageEntity;
import com.dianping.cat.report.alert.sender.sender.SenderManager;
import com.dianping.cat.report.page.event.service.EventReportService;
import com.dianping.cat.report.page.problem.service.ProblemReportService;
import com.dianping.cat.report.page.transaction.service.TransactionReportService;
import com.dianping.cat.report.task.TaskBuilder;
import com.dianping.cat.report.task.notify.AppDataComparisonNotifier;
import com.dianping.cat.report.task.notify.ReportRender;
import com.dianping.cat.service.ProjectService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.unidal.lookup.annotation.Inject;
import org.unidal.webres.helper.Splitters;

public class NotifyTaskBuilder
implements TaskBuilder {
    public static final String ID = "dailyNotify";
    @Inject
    private TransactionReportService m_transactionReportService;
    @Inject
    private EventReportService m_eventReportService;
    @Inject
    private ProblemReportService m_problemReportService;
    @Inject
    private SenderManager m_sendManager;
    @Inject
    private ReportRender m_render;
    @Inject
    private AppDataComparisonNotifier m_appDataInformer;
    @Inject
    private ServerFilterConfigManager m_serverConfigManager;
    @Inject
    private ProjectService m_projectService;
    private SimpleDateFormat m_sdf = new SimpleDateFormat("yyyy-MM-dd");
    private boolean m_active = false;

    private String renderContent(String domain, Date start) {
        Date end = new Date(start.getTime() + 86400000L);
        TransactionReport transactionReport = (TransactionReport)this.m_transactionReportService.queryReport(domain, start, end);
        EventReport eventReport = (EventReport)this.m_eventReportService.queryReport(domain, start, end);
        ProblemReport problemReport = (ProblemReport)this.m_problemReportService.queryReport(domain, start, end);
        StringBuilder sb = new StringBuilder(10240);
        sb.append(this.m_sdf.format(start)).append("</br>");
        sb.append(this.m_render.renderReport(transactionReport));
        sb.append(this.m_render.renderReport(eventReport));
        sb.append(this.m_render.renderReport(problemReport));
        return sb.toString();
    }

    private String renderTitle(String domain) {
        return " CAT \u65e5\u5e38\u62a5\u8868 [ " + domain + " ]";
    }

    public boolean buildDailyTask(String name, String domainName, Date period) {
        this.sendDailyReport(period);
        this.sendVsMeiTuanReport(period);
        return true;
    }

    private void sendVsMeiTuanReport(Date period) {
        this.m_appDataInformer.doNotifying(period);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDailyReport(Date period) {
        Date start = TimeHelper.getCurrentDay();
        Date end = new Date(start.getTime() + 3600000L);
        Set domains = this.m_transactionReportService.queryAllDomainNames(start, end, "transaction");
        for (String domain : domains) {
            if (!this.m_serverConfigManager.validateDomain(domain) || !this.m_active) continue;
            Transaction t = Cat.newTransaction((String)"ScheduledReport", (String)domain);
            try {
                String content = this.renderContent(domain, period);
                String title = this.renderTitle(domain);
                String email = this.m_projectService.findByDomain(domain).getEmail();
                List emails = Splitters.by((char)',').noEmptyItem().split(email);
                AlertMessageEntity message = new AlertMessageEntity(domain, title, "ScheduledJob", content, emails);
                this.m_sendManager.sendAlert(AlertChannel.MAIL, message);
                t.addData(emails.toString());
                t.setStatus("0");
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
                t.setStatus((Throwable)e);
            }
            finally {
                t.complete();
            }
        }
    }

    public boolean buildHourlyTask(String name, String domain, Date period) {
        throw new RuntimeException("daily report builder don't support hourly task");
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        throw new RuntimeException("daily report builder don't support monthly task");
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        throw new RuntimeException("daily report builder don't support weekly task");
    }
}

