/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task.notify;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.event.model.entity.EventReport;
import com.dianping.cat.consumer.problem.model.entity.ProblemReport;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.report.task.notify.ReportRender;
import com.dianping.cat.report.task.notify.render.EventRender;
import com.dianping.cat.report.task.notify.render.ProblemRender;
import com.dianping.cat.report.task.notify.render.TransactionRender;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

public class ReportRenderImpl
implements ReportRender,
Initializable {
    public Configuration m_configuration;
    private String m_ip = NetworkInterfaceManager.INSTANCE.getLocalHostAddress();

    public void initialize() throws InitializationException {
        this.m_configuration = new Configuration();
        this.m_configuration.setDefaultEncoding("UTF-8");
        try {
            this.m_configuration.setClassForTemplateLoading(ReportRenderImpl.class, "/freemaker");
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }

    public String renderReport(EventReport report) {
        EventRender entity = new EventRender(report.getStartTime(), report.getDomain(), 1, this.m_ip);
        entity.visitEventReport(report);
        Map root = entity.getRenderResult();
        StringWriter sw = new StringWriter(5000);
        try {
            Template t = this.m_configuration.getTemplate("event.ftl");
            t.process((Object)root, (Writer)sw);
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return sw.toString();
    }

    public String renderReport(ProblemReport report) {
        ProblemRender entity = new ProblemRender(report.getStartTime(), report.getDomain(), this.m_ip);
        entity.visitProblemReport(report);
        Map root = entity.getRenderResult();
        StringWriter sw = new StringWriter(5000);
        try {
            Template t = this.m_configuration.getTemplate("problem.ftl");
            t.process((Object)root, (Writer)sw);
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return sw.toString();
    }

    public String renderReport(TransactionReport report) {
        TransactionRender entity = new TransactionRender(report.getStartTime(), report.getDomain(), 1, this.m_ip);
        entity.visitTransactionReport(report);
        Map root = entity.getRenderResult();
        StringWriter sw = new StringWriter(5000);
        try {
            Template t = this.m_configuration.getTemplate("transaction.ftl");
            t.process((Object)root, (Writer)sw);
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return sw.toString();
    }

    public void setIp(String ip) {
        this.m_ip = ip;
    }
}

