/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task.notify.render;

import com.dianping.cat.consumer.event.model.entity.EventReport;
import com.dianping.cat.consumer.event.model.entity.EventType;
import com.dianping.cat.consumer.event.model.entity.Machine;
import com.dianping.cat.consumer.event.model.transform.BaseVisitor;
import com.dianping.cat.report.task.notify.render.EventRender;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventRender
extends BaseVisitor {
    private Date m_date;
    private String m_dateStr;
    private String m_domain;
    private String m_eventLink = "http://%s/cat/r/e?op=history&domain=%s&date=%s&reportType=day";
    private Map<Object, Object> m_result = new HashMap();
    private SimpleDateFormat m_sdf = new SimpleDateFormat("yyyyMMddHH");
    private int m_totalDays;
    private String m_currentIp;
    private String m_typeGraphLink = "http://%s/cat/r/e?op=historyGraph&domain=%s&date=%s&ip=All&reportType=day&type=%s";
    private List<Type> m_types = new ArrayList();
    private String m_ip;

    public EventRender(Date date, String domain, int day, String ip) {
        this.m_domain = domain;
        this.m_date = date;
        this.m_dateStr = this.m_sdf.format(date);
        this.m_totalDays = day;
        this.m_ip = ip;
    }

    private String buildEventUrl(Date date) {
        String dateStr = this.m_sdf.format(this.m_date);
        return String.format(this.m_eventLink, this.m_ip, this.m_domain, dateStr);
    }

    private String buildGraphUrl(EventType type) {
        return String.format(this.m_typeGraphLink, this.m_ip, this.m_domain, this.m_dateStr, type.getId());
    }

    public Map<Object, Object> getRenderResult() {
        return this.m_result;
    }

    public void visitEventReport(EventReport eventReport) {
        super.visitEventReport(eventReport);
        Date lastDay = new Date(this.m_date.getTime() - 86400000L);
        Date lastWeek = new Date(this.m_date.getTime() - 604800000L);
        String currentUrl = this.buildEventUrl(this.m_date);
        String lastDayUrl = this.buildEventUrl(lastDay);
        String lastWeekUrl = this.buildEventUrl(lastWeek);
        this.m_result.put("current", currentUrl);
        this.m_result.put("lastDay", lastDayUrl);
        this.m_result.put("lastWeek", lastWeekUrl);
        this.m_result.put("types", this.m_types);
    }

    public void visitMachine(Machine machine) {
        this.m_currentIp = machine.getIp();
        super.visitMachine(machine);
    }

    public void visitType(EventType type) {
        if (this.m_currentIp.equals("All")) {
            Type temp = new Type();
            type.setTps((double)type.getTotalCount() * 1000.0 / 8.64E7 / (double)this.m_totalDays);
            temp.setType(type);
            temp.setUrl(this.buildGraphUrl(type));
            this.m_types.add(temp);
        }
    }
}

