/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task.notify.render;

import com.dianping.cat.consumer.problem.model.entity.ProblemReport;
import com.dianping.cat.report.page.problem.transform.ProblemStatistics;
import com.dianping.cat.report.task.notify.render.ProblemRender;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemRender {
    private Date m_date;
    private String m_dateStr;
    private String m_domain;
    private Map<Object, Object> m_result = new HashMap();
    private List<Type> m_types = new ArrayList();
    private SimpleDateFormat m_sdf = new SimpleDateFormat("yyyyMMddHH");
    private String m_problemLink = "http://%s/cat/r/p?op=history&domain=%s&date=%s&reportType=day";
    private String m_typeGraphLink = "http://%s/cat/r/p?op=historyGraph&domain=%s&date=%s&ip=All&reportType=day&type=%s";
    private String m_ip;

    public ProblemRender(Date date, String domain, String ip) {
        this.m_domain = domain;
        this.m_date = date;
        this.m_dateStr = this.m_sdf.format(date);
        this.m_ip = ip;
    }

    private String buildGraphUrl(String type) {
        return String.format(this.m_typeGraphLink, this.m_ip, this.m_domain, this.m_dateStr, type);
    }

    private String buildProblemUrl(Date date) {
        String dateStr = this.m_sdf.format(this.m_date);
        return String.format(this.m_problemLink, this.m_ip, this.m_domain, dateStr);
    }

    public Map<Object, Object> getRenderResult() {
        return this.m_result;
    }

    public void visitProblemReport(ProblemReport report) {
        ProblemStatistics problemStatistics = new ProblemStatistics();
        problemStatistics.setAllIp(true);
        problemStatistics.visitProblemReport(report);
        Collection status = problemStatistics.getStatus().values();
        for (ProblemStatistics.TypeStatistics statistic : status) {
            String type = statistic.getType();
            int count = statistic.getCount();
            String graphUrl = this.buildGraphUrl(type);
            Type temp = new Type();
            temp.setType(type).setCount(count).setUrl(graphUrl);
            this.m_types.add(temp);
        }
        Date lastDay = new Date(this.m_date.getTime() - 86400000L);
        Date lastWeek = new Date(this.m_date.getTime() - 604800000L);
        String currentUrl = this.buildProblemUrl(this.m_date);
        String lastDayUrl = this.buildProblemUrl(lastDay);
        String lastWeekUrl = this.buildProblemUrl(lastWeek);
        this.m_result.put("current", currentUrl);
        this.m_result.put("lastDay", lastDayUrl);
        this.m_result.put("lastWeek", lastWeekUrl);
        this.m_result.put("types", this.m_types);
    }
}

