/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task.notify.render;

import com.dianping.cat.consumer.transaction.model.entity.Machine;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.consumer.transaction.model.entity.TransactionType;
import com.dianping.cat.consumer.transaction.model.transform.BaseVisitor;
import com.dianping.cat.report.task.notify.render.TransactionRender;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionRender
extends BaseVisitor {
    private Date m_date;
    private String m_dateStr;
    private String m_domain;
    private Map<Object, Object> m_result = new HashMap();
    private SimpleDateFormat m_sdf = new SimpleDateFormat("yyyyMMddHH");
    private int m_totalDays;
    private String m_currentIp;
    private String m_ip;
    private String m_transactionLink = "http://%s/cat/r/t?op=history&domain=%s&date=%s&reportType=day";
    private String m_typeGraphLink = "http://%s/cat/r/t?op=historyGraph&domain=%s&date=%s&ip=All&reportType=day&type=%s";
    private List<Type> m_types = new ArrayList();

    public TransactionRender(Date date, String domain, int day, String ip) {
        this.m_domain = domain;
        this.m_date = date;
        this.m_dateStr = this.m_sdf.format(date);
        this.m_totalDays = day;
        this.m_ip = ip;
    }

    private String buildGraphUrl(TransactionType type) {
        return String.format(this.m_typeGraphLink, this.m_ip, this.m_domain, this.m_dateStr, type.getId());
    }

    private String buildTransactionUrl(Date date) {
        String dateStr = this.m_sdf.format(this.m_date);
        return String.format(this.m_transactionLink, this.m_ip, this.m_domain, dateStr);
    }

    public Map<Object, Object> getRenderResult() {
        return this.m_result;
    }

    public void visitMachine(Machine machine) {
        this.m_currentIp = machine.getIp();
        super.visitMachine(machine);
    }

    public void visitTransactionReport(TransactionReport transactionReport) {
        super.visitTransactionReport(transactionReport);
        Date lastDay = new Date(this.m_date.getTime() - 86400000L);
        Date lastWeek = new Date(this.m_date.getTime() - 604800000L);
        String currentUrl = this.buildTransactionUrl(this.m_date);
        String lastDayUrl = this.buildTransactionUrl(lastDay);
        String lastWeekUrl = this.buildTransactionUrl(lastWeek);
        this.m_result.put("current", currentUrl);
        this.m_result.put("lastDay", lastDayUrl);
        this.m_result.put("lastWeek", lastWeekUrl);
        this.m_result.put("types", this.m_types);
    }

    public void visitType(TransactionType type) {
        if (this.m_currentIp.equals("All")) {
            Type temp = new Type();
            type.setTps((double)type.getTotalCount() * 1000.0 / 8.64E7 / (double)this.m_totalDays);
            temp.setType(type);
            temp.setUrl(this.buildGraphUrl(type));
            this.m_types.add(temp);
        }
    }
}

