/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.servlet;

import com.dianping.cat.Cat;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.unidal.initialization.DefaultModuleContext;
import org.unidal.initialization.ModuleContext;
import org.unidal.initialization.ModuleInitializer;
import org.unidal.web.AbstractContainerServlet;

public class CatServlet
extends AbstractContainerServlet {
    private static final long serialVersionUID = 1L;
    private Exception m_exception;

    private File getConfigFile(ServletConfig config, String name, String defaultConfigValue) {
        String configValue = config.getInitParameter(name);
        if (configValue != null) {
            if (configValue.startsWith("/")) {
                return new File(configValue);
            }
            return new File(Cat.getCatHome(), configValue);
        }
        return new File(Cat.getCatHome(), defaultConfigValue);
    }

    protected void initComponents(ServletConfig servletConfig) throws ServletException {
        try {
            DefaultModuleContext ctx = new DefaultModuleContext(this.getContainer());
            ModuleInitializer initializer = (ModuleInitializer)ctx.lookup(ModuleInitializer.class);
            File clientXmlFile = this.getConfigFile(servletConfig, "cat-client-xml", "client.xml");
            File serverXmlFile = this.getConfigFile(servletConfig, "cat-server-xml", "server.xml");
            ctx.setAttribute("cat-client-config-file", (Object)clientXmlFile);
            ctx.setAttribute("cat-server-config-file", (Object)serverXmlFile);
            initializer.execute((ModuleContext)ctx);
        }
        catch (Exception e) {
            this.m_exception = e;
            System.err.println(e);
            throw new ServletException((Throwable)e);
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setCharacterEncoding("utf-8");
        res.setContentType("text/plain");
        PrintWriter writer = res.getWriter();
        if (this.m_exception != null) {
            writer.write("Server has NOT been initialized successfully!\r\n\r\n");
            this.m_exception.printStackTrace(writer);
        } else {
            writer.write("Not implemented yet!");
        }
    }
}

