/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.config.processor;

import com.dianping.cat.Cat;
import com.dianping.cat.config.app.AppComparisonConfigManager;
import com.dianping.cat.config.app.AppConfigManager;
import com.dianping.cat.config.app.AppSpeedConfigManager;
import com.dianping.cat.config.app.command.CommandFormatConfigManager;
import com.dianping.cat.configuration.app.entity.Code;
import com.dianping.cat.configuration.app.entity.Command;
import com.dianping.cat.configuration.app.entity.Item;
import com.dianping.cat.configuration.app.speed.entity.Speed;
import com.dianping.cat.consumer.event.model.entity.EventReport;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.report.alert.app.AppRuleConfigManager;
import com.dianping.cat.report.alert.config.BaseRuleConfigManager;
import com.dianping.cat.report.page.event.service.EventReportService;
import com.dianping.cat.system.page.config.Action;
import com.dianping.cat.system.page.config.ConfigHtmlParser;
import com.dianping.cat.system.page.config.Model;
import com.dianping.cat.system.page.config.Payload;
import com.dianping.cat.system.page.config.processor.AppConfigProcessor;
import com.dianping.cat.system.page.config.processor.BaseProcesser;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.StringUtils;
import org.unidal.helper.Splitters;
import org.unidal.lookup.annotation.Inject;

public class AppConfigProcessor
extends BaseProcesser
implements Initializable {
    @Inject
    private AppRuleConfigManager m_appRuleConfigManager;
    @Inject
    private AppConfigManager m_appConfigManager;
    @Inject
    private AppSpeedConfigManager m_appSpeedConfigManager;
    @Inject
    private AppComparisonConfigManager m_appComparisonConfigManager;
    @Inject
    private EventReportService m_eventReportService;
    @Inject
    private CommandFormatConfigManager m_urlConfigManager;
    @Inject
    private ConfigHtmlParser m_configHtmlParser;
    private Set<String> m_invalids = new HashSet();

    public void appRuleBatchUpdate(Payload payload, Model model) {
        String[] paths;
        String content = payload.getContent();
        for (String path : paths = content.split(",")) {
            try {
                if (!StringUtils.isNotEmpty((String)path) || this.m_appConfigManager.getCommands().containsKey(path)) continue;
                Command command = new Command();
                command.setDomain("").setTitle(path).setName(path);
                this.m_appConfigManager.addCommand(command);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
    }

    private void buildAppConfigInfo(AppConfigManager appConfigManager, Model model) {
        model.setConnectionTypes(appConfigManager.queryConfigItem("\u8fde\u63a5\u7c7b\u578b"));
        model.setCities(appConfigManager.queryConfigItem("\u57ce\u5e02"));
        model.setNetworks(appConfigManager.queryConfigItem("\u7f51\u7edc\u7c7b\u578b"));
        model.setOperators(appConfigManager.queryConfigItem("\u8fd0\u8425\u5546"));
        model.setPlatforms(appConfigManager.queryConfigItem("\u5e73\u53f0"));
        model.setVersions(appConfigManager.queryConfigItem("\u7248\u672c"));
        model.setCommands(appConfigManager.queryCommands());
    }

    public void buildBatchApiConfig(Payload payload, Model model) {
        Date start = TimeHelper.getCurrentDay((int)-1);
        Date end = TimeHelper.getCurrentDay();
        EventReport report = (EventReport)this.m_eventReportService.queryReport("broker-service", start, end);
        EventReportVisitor visitor = new EventReportVisitor(this);
        visitor.visitEventReport(report);
        Set validatePaths = visitor.getPaths();
        Set invalidatePaths = visitor.getInvalidatePaths();
        Map commands = this.m_appConfigManager.getCommands();
        for (Map.Entry entry : commands.entrySet()) {
            validatePaths.remove(entry.getKey());
            invalidatePaths.remove(entry.getKey());
        }
        model.setValidatePaths(new ArrayList(validatePaths));
        model.setInvalidatePaths(new ArrayList(invalidatePaths));
    }

    private void buildListInfo(Model model, Payload payload) {
        int id = 0;
        List commands = this.m_appConfigManager.queryCommands();
        if ("code".equals(payload.getType()) && payload.getId() > 0) {
            id = payload.getId();
        } else if (!commands.isEmpty()) {
            id = ((Command)commands.iterator().next()).getId();
        }
        Command cmd = (Command)this.m_appConfigManager.getRawCommands().get(id);
        if (cmd != null) {
            model.setUpdateCommand(cmd);
            model.setId(String.valueOf(id));
        }
        this.buildBatchApiConfig(payload, model);
        model.setSpeeds(this.m_appSpeedConfigManager.getConfig().getSpeeds());
        model.setCodes(this.m_appConfigManager.getCodes());
    }

    public void initialize() throws InitializationException {
        this.m_invalids.add("jpg");
        this.m_invalids.add("http");
        this.m_invalids.add("file");
        this.m_invalids.add("zip");
        this.m_invalids.add("patch");
        this.m_invalids.add("dianping://");
        this.m_invalids.add("data:");
        this.m_invalids.add(".js");
        this.m_invalids.add("OTHERS");
        this.m_invalids.add("hit-");
    }

    public void process(Action action, Payload payload, Model model) {
        switch (1.$SwitchMap$com$dianping$cat$system$page$config$Action[action.ordinal()]) {
            case 1: {
                if (this.m_appConfigManager.isNameDuplicate(payload.getName())) {
                    model.setNameUniqueResult("{\"isNameUnique\" : false}");
                    break;
                }
                model.setNameUniqueResult("{\"isNameUnique\" : true}");
                break;
            }
            case 2: {
                this.buildListInfo(model, payload);
                break;
            }
            case 3: {
                int id = payload.getId();
                if (!this.m_appConfigManager.containCommand(id)) break;
                Command command = this.m_appConfigManager.getConfig().findCommand(Integer.valueOf(id));
                if (command == null) {
                    command = new Command();
                }
                model.setUpdateCommand(command);
                break;
            }
            case 4: {
                int id = payload.getId();
                String domain = payload.getDomain();
                String name = payload.getName();
                String title = payload.getTitle();
                boolean all = payload.isAll();
                int timeThreshold = payload.getThreshold();
                if (this.m_appConfigManager.containCommand(id)) {
                    Command command = new Command();
                    command.setDomain(domain).setName(name).setTitle(title).setAll(all).setThreshold(timeThreshold);
                    if (this.m_appConfigManager.updateCommand(id, command)) {
                        model.setOpState(true);
                    } else {
                        model.setOpState(false);
                    }
                } else {
                    try {
                        Command command = new Command().setDomain(domain).setTitle(title).setName(name).setAll(all).setThreshold(timeThreshold);
                        if (((Boolean)this.m_appConfigManager.addCommand(command).getKey()).booleanValue()) {
                            model.setOpState(true);
                        } else {
                            model.setOpState(false);
                        }
                    }
                    catch (Exception e) {
                        model.setOpState(false);
                    }
                }
                this.buildListInfo(model, payload);
                break;
            }
            case 5: {
                int id = payload.getId();
                if (this.m_appConfigManager.deleteCommand(id)) {
                    this.m_appRuleConfigManager.deleteByCommandId(id);
                    model.setOpState(true);
                } else {
                    model.setOpState(false);
                }
                this.buildListInfo(model, payload);
                break;
            }
            case 6: {
                int id = payload.getId();
                int codeId = payload.getCode();
                if (payload.isConstant()) {
                    Code code = (Code)this.m_appConfigManager.getConfig().getCodes().get(codeId);
                    model.setCode(code);
                    break;
                }
                Command cmd = (Command)this.m_appConfigManager.getRawCommands().get(id);
                if (cmd == null) break;
                Code code = (Code)cmd.getCodes().get(codeId);
                model.setCode(code);
                model.setUpdateCommand(cmd);
                break;
            }
            case 7: {
                try {
                    int id = payload.getId();
                    String codeStr = payload.getContent();
                    List strs = Splitters.by((String)":").split(codeStr);
                    int codeId = Integer.parseInt((String)strs.get(0));
                    String name = (String)strs.get(1);
                    int status = Integer.parseInt((String)strs.get(2));
                    Code code = new Code(Integer.valueOf(codeId));
                    code.setName(name).setStatus(Integer.valueOf(status));
                    if (payload.isConstant()) {
                        this.m_appConfigManager.updateCode(code);
                    } else {
                        this.m_appConfigManager.updateCode(id, code);
                    }
                    this.buildListInfo(model, payload);
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
                break;
            }
            case 8: {
                int id = payload.getId();
                model.setId(String.valueOf(id));
                break;
            }
            case 9: {
                try {
                    int id = payload.getId();
                    int codeId = payload.getCode();
                    if (payload.isConstant()) {
                        this.m_appConfigManager.getCodes().remove(codeId);
                    } else {
                        this.m_appConfigManager.deleteCode(id, codeId);
                    }
                    this.buildListInfo(model, payload);
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
                break;
            }
            case 10: 
            case 11: {
                int id = payload.getId();
                Speed speed = (Speed)this.m_appSpeedConfigManager.getConfig().getSpeeds().get(id);
                if (speed == null) break;
                model.setSpeed(speed);
                break;
            }
            case 12: {
                try {
                    int id = payload.getId();
                    this.m_appSpeedConfigManager.deleteSpeed(id);
                    this.buildListInfo(model, payload);
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
                break;
            }
            case 13: {
                try {
                    int id = payload.getId();
                    String speedStr = payload.getContent();
                    List strs = Splitters.by((String)":").split(speedStr);
                    String page = ((String)strs.get(0)).trim();
                    int step = Integer.parseInt(((String)strs.get(1)).trim());
                    String title = ((String)strs.get(2)).trim();
                    int threshold = Integer.parseInt(((String)strs.get(3)).trim());
                    int speedId = id > 0 ? id : this.m_appSpeedConfigManager.generateId();
                    Speed speed = new Speed(speedId);
                    speed.setPage(page).setStep(step).setTitle(title).setThreshold(threshold);
                    this.m_appSpeedConfigManager.updateConfig(speed);
                    this.buildListInfo(model, payload);
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
                break;
            }
            case 14: {
                String appConfig = payload.getContent();
                if (!StringUtils.isEmpty((String)appConfig)) {
                    model.setOpState(this.m_appConfigManager.insert(appConfig));
                }
                model.setContent(this.m_configHtmlParser.parse(this.m_appConfigManager.getConfig().toString()));
                break;
            }
            case 15: {
                this.buildAppConfigInfo(this.m_appConfigManager, model);
                model.setRules(this.m_appRuleConfigManager.getMonitorRules().getRules().values());
                break;
            }
            case 16: {
                this.buildAppConfigInfo(this.m_appConfigManager, model);
                this.generateRuleConfigContent(payload.getRuleId(), (BaseRuleConfigManager)this.m_appRuleConfigManager, model);
                break;
            }
            case 17: {
                this.buildAppConfigInfo(this.m_appConfigManager, model);
                model.setOpState(this.addSubmitRule((BaseRuleConfigManager)this.m_appRuleConfigManager, payload.getRuleId(), "", payload.getConfigs()));
                model.setRules(this.m_appRuleConfigManager.getMonitorRules().getRules().values());
                break;
            }
            case 18: {
                this.buildAppConfigInfo(this.m_appConfigManager, model);
                model.setOpState(this.deleteRule((BaseRuleConfigManager)this.m_appRuleConfigManager, payload.getRuleId()));
                model.setRules(this.m_appRuleConfigManager.getMonitorRules().getRules().values());
                break;
            }
            case 19: {
                String appComparisonConfig = payload.getContent();
                if (!StringUtils.isEmpty((String)appComparisonConfig)) {
                    model.setOpState(this.m_appComparisonConfigManager.insert(appComparisonConfig));
                }
                model.setContent(this.m_configHtmlParser.parse(this.m_appComparisonConfigManager.getConfig().toString()));
                break;
            }
            case 20: {
                this.appRuleBatchUpdate(payload, model);
                this.buildListInfo(model, payload);
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                Item item = this.m_appConfigManager.queryItem(payload.getType(), payload.getId());
                model.setAppItem(item);
                break;
            }
            case 23: {
                try {
                    int id = payload.getId();
                    String content = payload.getContent();
                    String[] strs = content.split(":");
                    String type = strs[0];
                    int constantId = Integer.valueOf(strs[1]);
                    String value = strs[2];
                    model.setOpState(this.m_appConfigManager.addConstant(type, constantId, value));
                    this.buildListInfo(model, payload);
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
                break;
            }
            case 24: {
                String content = payload.getContent();
                if (StringUtils.isNotEmpty((String)content)) {
                    this.m_urlConfigManager.insert(content);
                }
                model.setContent(this.m_configHtmlParser.parse(this.m_urlConfigManager.getUrlFormat().toString()));
                break;
            }
            default: {
                throw new RuntimeException("Error action name " + action.getName());
            }
        }
    }

    static /* synthetic */ Set access$000(AppConfigProcessor x0) {
        return x0.m_invalids;
    }
}

