/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.config.processor;

import com.dianping.cat.home.bug.entity.BugReport;
import com.dianping.cat.home.bug.entity.Domain;
import com.dianping.cat.home.exception.entity.ExceptionExclude;
import com.dianping.cat.home.exception.entity.ExceptionLimit;
import com.dianping.cat.report.alert.exception.ExceptionRuleConfigManager;
import com.dianping.cat.report.page.statistics.service.BugReportService;
import com.dianping.cat.system.page.config.Action;
import com.dianping.cat.system.page.config.Model;
import com.dianping.cat.system.page.config.Payload;
import com.dianping.cat.system.page.config.processor.ExceptionConfigProcessor;
import com.dianping.cat.system.page.config.processor.GlobalConfigProcessor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionConfigProcessor {
    @Inject
    private GlobalConfigProcessor m_globalConfigProcessor;
    @Inject
    private ExceptionRuleConfigManager m_exceptionRuleConfigManager;
    @Inject
    private BugReportService m_reportService;

    private void deleteExceptionExclude(Payload payload) {
        this.m_exceptionRuleConfigManager.deleteExceptionExclude(payload.getDomain(), payload.getException());
    }

    private void deleteExceptionLimit(Payload payload) {
        this.m_exceptionRuleConfigManager.deleteExceptionLimit(payload.getDomain(), payload.getException());
    }

    private void loadExceptionConfig(Model model) {
        model.setExceptionExcludes(this.m_exceptionRuleConfigManager.queryAllExceptionExcludes());
        model.setExceptionLimits(this.m_exceptionRuleConfigManager.queryAllExceptionLimits());
    }

    public void process(Action action, Payload payload, Model model) {
        switch (1.$SwitchMap$com$dianping$cat$system$page$config$Action[action.ordinal()]) {
            case 1: {
                this.loadExceptionConfig(model);
                break;
            }
            case 2: {
                this.deleteExceptionLimit(payload);
                this.loadExceptionConfig(model);
                break;
            }
            case 3: {
                model.setExceptionLimit(this.m_exceptionRuleConfigManager.queryExceptionLimit(payload.getDomain(), payload.getException()));
                break;
            }
            case 4: {
                List exceptionThresholdList = this.queryExceptionList();
                exceptionThresholdList.add(ExceptionRuleConfigManager.TOTAL_STRING);
                model.setExceptionList(exceptionThresholdList);
                model.setDomainList(this.m_globalConfigProcessor.queryDoaminList());
                break;
            }
            case 5: {
                this.updateExceptionLimit(payload);
                this.loadExceptionConfig(model);
                break;
            }
            case 6: {
                this.deleteExceptionExclude(payload);
                this.loadExceptionConfig(model);
                break;
            }
            case 7: {
                List exceptionExcludeList = this.queryExceptionList();
                model.setExceptionList(exceptionExcludeList);
                model.setDomainList(this.m_globalConfigProcessor.queryDoaminList());
                break;
            }
            case 8: {
                this.updateExceptionExclude(payload);
                this.loadExceptionConfig(model);
                break;
            }
            default: {
                throw new RuntimeException("Error action name " + action.getName());
            }
        }
    }

    private List<String> queryExceptionList() {
        long current = System.currentTimeMillis();
        Date start = new Date(current - current % 3600000L - 3600000L - 86400000L);
        Date end = new Date(start.getTime() + 3600000L);
        BugReport report = (BugReport)this.m_reportService.queryReport("cat", start, end);
        HashSet keys = new HashSet();
        ArrayList<String> exceptions = new ArrayList<String>();
        for (Map.Entry domain : report.getDomains().entrySet()) {
            keys.addAll(((Domain)domain.getValue()).getExceptionItems().keySet());
        }
        for (String key : keys) {
            exceptions.add(key.replaceAll("\n", " ").trim());
        }
        return exceptions;
    }

    private void updateExceptionExclude(Payload payload) {
        ExceptionExclude exclude = payload.getExceptionExclude();
        exclude.setDomain(exclude.getDomain().trim());
        exclude.setName(exclude.getName().trim());
        exclude.setId(exclude.getDomain() + ":" + exclude.getName());
        if (StringUtils.isNotEmpty((String)exclude.getDomain()) && StringUtils.isNotEmpty((String)exclude.getName())) {
            this.m_exceptionRuleConfigManager.insertExceptionExclude(exclude);
        }
    }

    private void updateExceptionLimit(Payload payload) {
        ExceptionLimit limit = payload.getExceptionLimit();
        limit.setDomain(limit.getDomain().trim());
        limit.setName(limit.getName().trim());
        limit.setId(limit.getDomain() + ":" + limit.getName());
        if (StringUtils.isNotEmpty((String)limit.getDomain()) && StringUtils.isNotEmpty((String)limit.getName())) {
            this.m_exceptionRuleConfigManager.insertExceptionLimit(limit);
        }
    }
}

