/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.config.processor;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.BlackListManager;
import com.dianping.cat.config.server.ServerFilterConfigManager;
import com.dianping.cat.consumer.config.AllReportConfigManager;
import com.dianping.cat.core.dal.Project;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.home.group.entity.Domain;
import com.dianping.cat.report.alert.sender.config.SenderConfigManager;
import com.dianping.cat.report.page.DomainGroupConfigManager;
import com.dianping.cat.report.page.statistics.config.BugConfigManager;
import com.dianping.cat.report.page.storage.config.StorageGroupConfigManager;
import com.dianping.cat.service.ProjectService;
import com.dianping.cat.system.page.config.Action;
import com.dianping.cat.system.page.config.ConfigHtmlParser;
import com.dianping.cat.system.page.config.Model;
import com.dianping.cat.system.page.config.Payload;
import com.dianping.cat.system.page.config.processor.GlobalConfigProcessor;
import com.dianping.cat.system.page.router.config.RouterConfigHandler;
import com.dianping.cat.system.page.router.config.RouterConfigManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalConfigProcessor {
    @Inject
    public ProjectService m_projectService;
    @Inject
    private BugConfigManager m_bugConfigManager;
    @Inject
    private RouterConfigManager m_routerConfigManager;
    @Inject
    private DomainGroupConfigManager m_domainGroupConfigManger;
    @Inject
    private SenderConfigManager m_senderConfigManager;
    @Inject
    private BlackListManager m_blackListManager;
    @Inject
    private StorageGroupConfigManager m_groupConfigManager;
    @Inject
    private ServerFilterConfigManager m_serverFilterConfigManager;
    @Inject
    private AllReportConfigManager m_transactionConfigManager;
    @Inject
    private ConfigHtmlParser m_configHtmlParser;
    @Inject
    private RouterConfigHandler m_routerConfigHandler;

    private boolean deleteProject(Payload payload) {
        Project proto = new Project();
        int id = payload.getProjectId();
        proto.setId(id);
        proto.setKeyId(id);
        return this.m_projectService.delete(proto);
    }

    public void process(Action action, Payload payload, Model model) {
        switch (1.$SwitchMap$com$dianping$cat$system$page$config$Action[action.ordinal()]) {
            case 1: {
                String domain = payload.getDomain();
                if (StringUtils.isEmpty((String)domain)) {
                    domain = "cat";
                }
                model.setProjects(this.queryAllProjects());
                model.setProject(this.m_projectService.findByDomain(domain));
                break;
            }
            case 2: {
                model.setOpState(this.updateProject(payload));
                String domain = payload.getDomain();
                if (StringUtils.isEmpty((String)domain) && StringUtils.isEmpty((String)(domain = payload.getProject().getDomain()))) {
                    domain = "cat";
                }
                model.setProjects(this.queryAllProjects());
                model.setProject(this.m_projectService.findByDomain(domain));
                break;
            }
            case 3: {
                model.setOpState(this.deleteProject(payload));
                String domain = payload.getDomain();
                if (StringUtils.isEmpty((String)domain)) {
                    domain = "cat";
                }
                model.setProjects(this.queryAllProjects());
                model.setProject(this.m_projectService.findByDomain(domain));
                break;
            }
            case 4: {
                model.setDomainGroup(this.m_domainGroupConfigManger.getDomainGroup());
                break;
            }
            case 5: {
                String domain = payload.getDomain();
                Domain groupDomain = this.m_domainGroupConfigManger.queryGroupDomain(domain);
                model.setGroupDomain(groupDomain);
                break;
            }
            case 6: {
                this.m_domainGroupConfigManger.deleteGroup(payload.getDomain());
                model.setDomainGroup(this.m_domainGroupConfigManger.getDomainGroup());
                break;
            }
            case 7: {
                this.m_domainGroupConfigManger.insertFromJson(payload.getContent());
                model.setDomainGroup(this.m_domainGroupConfigManger.getDomainGroup());
                break;
            }
            case 8: {
                String xml = payload.getBug();
                if (!StringUtils.isEmpty((String)xml)) {
                    model.setOpState(this.m_bugConfigManager.insert(xml));
                } else {
                    model.setOpState(true);
                }
                model.setBug(this.m_configHtmlParser.parse(this.m_bugConfigManager.getBugConfig().toString()));
                break;
            }
            case 9: {
                String routerConfig = payload.getContent();
                if (!StringUtils.isEmpty((String)routerConfig)) {
                    model.setOpState(this.m_routerConfigManager.insert(routerConfig));
                    this.m_routerConfigHandler.updateRouterConfig(TimeHelper.getCurrentDay((int)-1));
                }
                model.setContent(this.m_configHtmlParser.parse(this.m_routerConfigManager.getRouterConfig().toString()));
                break;
            }
            case 10: {
                String senderConfig = payload.getContent();
                if (!StringUtils.isEmpty((String)senderConfig)) {
                    model.setOpState(this.m_senderConfigManager.insert(senderConfig));
                }
                model.setContent(this.m_configHtmlParser.parse(this.m_senderConfigManager.getConfig().toString()));
                break;
            }
            case 11: {
                String blackConfig = payload.getContent();
                if (!StringUtils.isEmpty((String)blackConfig)) {
                    model.setOpState(this.m_blackListManager.insert(blackConfig));
                } else {
                    model.setOpState(true);
                }
                model.setContent(this.m_configHtmlParser.parse(this.m_blackListManager.getBlackList().toString()));
                break;
            }
            case 12: {
                String storageGroup = payload.getContent();
                if (!StringUtils.isEmpty((String)storageGroup)) {
                    model.setOpState(this.m_groupConfigManager.insert(storageGroup));
                }
                model.setContent(this.m_configHtmlParser.parse(this.m_groupConfigManager.getConfig().toString()));
                break;
            }
            case 13: {
                String serverConfig = payload.getContent();
                if (!StringUtils.isEmpty((String)serverConfig)) {
                    model.setOpState(this.m_serverFilterConfigManager.insert(serverConfig));
                }
                model.setContent(this.m_configHtmlParser.parse(this.m_serverFilterConfigManager.getConfig().toString()));
                break;
            }
            case 14: {
                String transactionConfig = payload.getContent();
                if (!StringUtils.isEmpty((String)transactionConfig)) {
                    model.setOpState(this.m_transactionConfigManager.insert(transactionConfig));
                }
                model.setContent(this.m_configHtmlParser.parse(this.m_transactionConfigManager.getConfig().toString()));
                break;
            }
        }
    }

    public List<Project> queryAllProjects() {
        ArrayList<Project> projects = new ArrayList();
        try {
            projects = this.m_projectService.findAll();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        Collections.sort(projects, new ProjectCompartor());
        return projects;
    }

    public List<String> queryDoaminList() {
        ArrayList<String> result = new ArrayList<String>();
        List projects = this.queryAllProjects();
        result.add("Default");
        for (Project p : projects) {
            result.add(p.getDomain());
        }
        return result;
    }

    private boolean updateProject(Payload payload) {
        Project project = payload.getProject();
        project.setKeyId(project.getId());
        return this.m_projectService.update(project);
    }
}

