/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.config.processor;

import com.dianping.cat.consumer.company.model.entity.ProductLine;
import com.dianping.cat.consumer.config.ProductLineConfigManager;
import com.dianping.cat.consumer.metric.MetricConfigManager;
import com.dianping.cat.consumer.metric.config.entity.MetricItemConfig;
import com.dianping.cat.home.rule.entity.Rule;
import com.dianping.cat.home.rule.transform.DefaultJsonBuilder;
import com.dianping.cat.report.alert.business.BusinessRuleConfigManager;
import com.dianping.cat.report.alert.config.BaseRuleConfigManager;
import com.dianping.cat.system.page.config.Action;
import com.dianping.cat.system.page.config.ConfigHtmlParser;
import com.dianping.cat.system.page.config.Model;
import com.dianping.cat.system.page.config.Payload;
import com.dianping.cat.system.page.config.processor.BaseProcesser;
import com.dianping.cat.system.page.config.processor.GlobalConfigProcessor;
import com.dianping.cat.system.page.config.processor.MetricConfigProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;

public class MetricConfigProcessor
extends BaseProcesser {
    @Inject
    private GlobalConfigProcessor m_globalConfigManager;
    @Inject
    private ProductLineConfigManager m_productLineConfigManger;
    @Inject
    private MetricConfigManager m_metricConfigManager;
    @Inject
    private BusinessRuleConfigManager m_businessRuleConfigManager;
    @Inject
    private ConfigHtmlParser m_configHtmlParser;

    private void metricConfigAdd(Payload payload, Model model) {
        String key = this.m_metricConfigManager.buildMetricKey(payload.getDomain(), payload.getType(), payload.getMetricKey());
        model.setMetricItemConfig(this.m_metricConfigManager.queryMetricItemConfig(key));
    }

    private boolean metricConfigAddSubmit(Payload payload, Model model) {
        MetricItemConfig config = payload.getMetricItemConfig();
        String domain = config.getDomain();
        String type = config.getType();
        String metricKey = config.getMetricKey();
        if (!(StringUtils.isEmpty((String)domain) || StringUtils.isEmpty((String)type) || StringUtils.isEmpty((String)metricKey))) {
            config.setId(this.m_metricConfigManager.buildMetricKey(domain, type, metricKey));
            return this.m_metricConfigManager.insertMetricItemConfig(config);
        }
        return false;
    }

    private void metricConfigList(Payload payload, Model model) {
        Map productLines = this.m_productLineConfigManger.queryMetricProductLines();
        LinkedHashMap<ProductLine, List> metricConfigs = new LinkedHashMap<ProductLine, List>();
        HashSet<String> exists = new HashSet<String>();
        HashSet knowDomains = new HashSet();
        for (Map.Entry entry : productLines.entrySet()) {
            ProductLine productLine = (ProductLine)entry.getValue();
            Set domains = productLine.getDomains().keySet();
            List configs = this.m_metricConfigManager.queryMetricItemConfigs(domains);
            for (MetricItemConfig config : configs) {
                exists.add(this.m_metricConfigManager.buildMetricKey(config.getDomain(), config.getType(), config.getMetricKey()));
            }
            metricConfigs.put(productLine, configs);
            knowDomains.addAll(domains);
        }
        Iterator iterator = productLines.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry;
            entry = iterator.next();
            payload.setProductLineName((String)entry.getKey());
        }
        ArrayList<MetricItemConfig> otherConfigs = new ArrayList<MetricItemConfig>();
        for (MetricItemConfig config : this.m_metricConfigManager.getMetricConfig().getMetricItemConfigs().values()) {
            String domain = config.getDomain();
            if (knowDomains.contains(domain)) continue;
            otherConfigs.add(config);
        }
        if (!otherConfigs.isEmpty()) {
            metricConfigs.put(new ProductLine("Other").setTitle("Other"), otherConfigs);
        }
        model.setProductMetricConfigs(metricConfigs);
    }

    private void metricRuleAdd(Payload payload, Model model) {
        String ruleId = "";
        String configHeader = "";
        String configsStr = "";
        String key = this.m_metricConfigManager.buildMetricKey(payload.getDomain(), payload.getType(), payload.getMetricKey());
        Rule rule = this.m_businessRuleConfigManager.queryRule(payload.getProductLineName(), key);
        if (rule != null) {
            ruleId = rule.getId();
            configHeader = new DefaultJsonBuilder(true).buildArray((Collection)rule.getMetricItems());
            configsStr = new DefaultJsonBuilder(true).buildArray((Collection)rule.getConfigs());
        }
        String content = this.m_ruleDecorator.generateConfigsHtml(configsStr);
        model.setId(ruleId);
        model.setConfigHeader(configHeader);
        model.setContent(content);
    }

    public void process(Action action, Payload payload, Model model) {
        switch (1.$SwitchMap$com$dianping$cat$system$page$config$Action[action.ordinal()]) {
            case 1: {
                this.metricConfigAdd(payload, model);
                model.setProductLines(this.m_productLineConfigManger.queryAllProductLines());
                ProductLine productLine = (ProductLine)this.m_productLineConfigManger.queryAllProductLines().get(payload.getProductLineName());
                if (productLine != null) {
                    model.setProductLineToDomains(productLine.getDomains());
                }
                model.setProjects(this.m_globalConfigManager.queryAllProjects());
                List tags = this.m_metricConfigManager.queryTags();
                model.setTags(tags);
                break;
            }
            case 2: {
                model.setOpState(this.metricConfigAddSubmit(payload, model));
                this.metricConfigList(payload, model);
                break;
            }
            case 3: {
                this.metricRuleAdd(payload, model);
                break;
            }
            case 4: {
                model.setOpState(this.addSubmitRule((BaseRuleConfigManager)this.m_businessRuleConfigManager, payload.getRuleId(), payload.getMetrics(), payload.getConfigs()));
                this.metricConfigList(payload, model);
                break;
            }
            case 5: {
                this.metricConfigList(payload, model);
                break;
            }
            case 6: {
                model.setOpState(this.m_metricConfigManager.deleteDomainConfig(this.m_metricConfigManager.buildMetricKey(payload.getDomain(), payload.getType(), payload.getMetricKey())));
                this.metricConfigList(payload, model);
                break;
            }
            case 7: {
                model.setOpState(this.m_metricConfigManager.deleteBatchDomainConfig(payload.getDomain()));
                this.metricConfigList(payload, model);
                break;
            }
            case 8: {
                String domainMetricRuleConfig = payload.getContent();
                if (!StringUtils.isEmpty((String)domainMetricRuleConfig)) {
                    model.setOpState(this.m_businessRuleConfigManager.insert(domainMetricRuleConfig));
                } else {
                    model.setOpState(true);
                }
                model.setContent(this.m_configHtmlParser.parse(this.m_businessRuleConfigManager.getMonitorRules().toString()));
                break;
            }
            default: {
                throw new RuntimeException("Error action name " + action.getName());
            }
        }
    }
}

