/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.config.processor;

import com.dianping.cat.home.alert.thirdparty.entity.Http;
import com.dianping.cat.home.alert.thirdparty.entity.Par;
import com.dianping.cat.home.alert.thirdparty.entity.Socket;
import com.dianping.cat.report.alert.thirdParty.ThirdPartyConfigManager;
import com.dianping.cat.system.page.config.Action;
import com.dianping.cat.system.page.config.Model;
import com.dianping.cat.system.page.config.Payload;
import com.dianping.cat.system.page.config.processor.ThirdPartyConfigProcessor;
import java.util.ArrayList;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.tuple.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThirdPartyConfigProcessor {
    @Inject
    private ThirdPartyConfigManager m_thirdPartyConfigManager;

    public void process(Action action, Payload payload, Model model) {
        switch (1.$SwitchMap$com$dianping$cat$system$page$config$Action[action.ordinal()]) {
            case 1: {
                model.setThirdPartyConfig(this.m_thirdPartyConfigManager.getConfig());
                break;
            }
            case 2: {
                Pair pair = this.queryThirdPartyConfigInfo(payload);
                if (pair == null) break;
                model.setHttp((Http)pair.getKey());
                model.setSocket((Socket)pair.getValue());
                break;
            }
            case 3: {
                String type = payload.getType();
                if ("http".equals(type)) {
                    this.m_thirdPartyConfigManager.insert(this.buildHttp(payload));
                }
                if ("socket".equals(type)) {
                    this.m_thirdPartyConfigManager.insert(payload.getSocket());
                }
                model.setThirdPartyConfig(this.m_thirdPartyConfigManager.getConfig());
                break;
            }
            case 4: {
                String type = payload.getType();
                String ruleId = payload.getRuleId();
                this.m_thirdPartyConfigManager.remove(ruleId, type);
                model.setThirdPartyConfig(this.m_thirdPartyConfigManager.getConfig());
                break;
            }
            default: {
                throw new RuntimeException("Error action name " + action.getName());
            }
        }
    }

    private Http buildHttp(Payload payload) {
        Http http = payload.getHttp();
        String[] pars = payload.getPars().split(",");
        ArrayList<Par> lst = new ArrayList<Par>();
        for (int i = 0; i < pars.length; ++i) {
            if (!StringUtils.isNotEmpty((String)pars[i])) continue;
            Par par = new Par();
            String id = pars[i].trim();
            if (!id.contains("=")) {
                Par p = (Par)lst.get(lst.size() - 1);
                p.setId(p.getId() + "," + id);
                continue;
            }
            par.setId(id);
            lst.add(par);
        }
        for (Par p : lst) {
            http.addPar(p);
        }
        return http;
    }

    private Pair<Http, Socket> queryThirdPartyConfigInfo(Payload payload) {
        String ruleId = payload.getRuleId();
        String type = payload.getType();
        Http http = null;
        Socket socket = null;
        if (StringUtils.isNotEmpty((String)ruleId)) {
            if ("http".equals(type)) {
                http = this.m_thirdPartyConfigManager.queryHttp(ruleId);
            } else if ("socket".equals(type)) {
                socket = this.m_thirdPartyConfigManager.querySocket(ruleId);
            }
            return new Pair((Object)http, (Object)socket);
        }
        return null;
    }
}

