/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.config.processor;

import com.dianping.cat.Cat;
import com.dianping.cat.config.app.AppConfigManager;
import com.dianping.cat.config.web.js.AggregationConfigManager;
import com.dianping.cat.config.web.url.UrlPatternConfigManager;
import com.dianping.cat.configuration.web.js.entity.AggregationRule;
import com.dianping.cat.configuration.web.url.entity.PatternItem;
import com.dianping.cat.report.alert.config.BaseRuleConfigManager;
import com.dianping.cat.report.alert.web.WebRuleConfigManager;
import com.dianping.cat.report.page.web.CityManager;
import com.dianping.cat.system.page.config.Action;
import com.dianping.cat.system.page.config.ConfigHtmlParser;
import com.dianping.cat.system.page.config.Model;
import com.dianping.cat.system.page.config.Payload;
import com.dianping.cat.system.page.config.processor.BaseProcesser;
import com.dianping.cat.system.page.config.processor.WebConfigProcessor;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;

public class WebConfigProcessor
extends BaseProcesser {
    @Inject
    private UrlPatternConfigManager m_urlPatternConfigManager;
    @Inject
    private AggregationConfigManager m_aggreationConfigManager;
    @Inject
    private WebRuleConfigManager m_webRuleConfigManager;
    @Inject
    private CityManager m_cityManager;
    @Inject
    private AppConfigManager m_appConfigManager;
    @Inject
    private ConfigHtmlParser m_configHtmlParser;

    private void buildWebConfigInfo(Model model) {
        Map patterns = this.m_urlPatternConfigManager.getId2Items();
        model.setCities(this.m_appConfigManager.queryConfigItem("\u57ce\u5e02"));
        model.setOperators(this.m_appConfigManager.queryConfigItem("\u8fd0\u8425\u5546"));
        model.setPatternItems(patterns);
        model.setWebCodes(this.m_urlPatternConfigManager.getUrlPattern().getCodes());
    }

    private void deleteAggregationRule(Payload payload) {
        this.m_aggreationConfigManager.deleteAggregationRule(payload.getPattern());
    }

    public void processPatternConfig(Action action, Payload payload, Model model) {
        switch (1.$SwitchMap$com$dianping$cat$system$page$config$Action[action.ordinal()]) {
            case 1: {
                model.setAggregationRules(this.m_aggreationConfigManager.queryAggregationRules());
                break;
            }
            case 2: {
                model.setAggregationRule(this.m_aggreationConfigManager.queryAggration(payload.getPattern()));
                break;
            }
            case 3: {
                this.updateAggregationRule(payload);
                model.setAggregationRules(this.m_aggreationConfigManager.queryAggregationRules());
                break;
            }
            case 4: {
                this.deleteAggregationRule(payload);
                model.setAggregationRules(this.m_aggreationConfigManager.queryAggregationRules());
                break;
            }
            case 5: {
                String config = payload.getContent();
                if (!StringUtils.isEmpty((String)config)) {
                    model.setOpState(this.m_urlPatternConfigManager.insert(config));
                }
                model.setContent(this.m_configHtmlParser.parse(this.m_urlPatternConfigManager.getUrlPattern().toString()));
                break;
            }
            case 6: {
                model.setPatternItems(this.m_urlPatternConfigManager.getId2Items());
                break;
            }
            case 7: {
                model.setPatternItem(this.m_urlPatternConfigManager.queryUrlPattern(payload.getKey()));
                break;
            }
            case 8: {
                try {
                    String key = payload.getKey();
                    PatternItem patternItem = payload.getPatternItem();
                    if (this.m_urlPatternConfigManager.queryUrlPatterns().containsKey(key)) {
                        int id = payload.getId();
                        patternItem.setId(id);
                        this.m_urlPatternConfigManager.updatePatternItem(patternItem);
                    } else {
                        this.m_urlPatternConfigManager.insertPatternItem(patternItem);
                    }
                    model.setPatternItems(this.m_urlPatternConfigManager.getId2Items());
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
                break;
            }
            case 9: {
                this.m_urlPatternConfigManager.deletePatternItem(payload.getKey());
                model.setPatternItems(this.m_urlPatternConfigManager.getId2Items());
                break;
            }
            case 10: {
                this.buildWebConfigInfo(model);
                model.setRules(this.m_webRuleConfigManager.getMonitorRules().getRules().values());
                break;
            }
            case 11: {
                this.buildWebConfigInfo(model);
                this.generateRuleConfigContent(payload.getRuleId(), (BaseRuleConfigManager)this.m_webRuleConfigManager, model);
                break;
            }
            case 12: {
                this.buildWebConfigInfo(model);
                model.setRules(this.m_webRuleConfigManager.getMonitorRules().getRules().values());
                model.setOpState(this.addSubmitRule((BaseRuleConfigManager)this.m_webRuleConfigManager, payload.getRuleId(), "", payload.getConfigs()));
                break;
            }
            case 13: {
                this.buildWebConfigInfo(model);
                model.setRules(this.m_webRuleConfigManager.getMonitorRules().getRules().values());
                model.setOpState(this.deleteRule((BaseRuleConfigManager)this.m_webRuleConfigManager, payload.getRuleId()));
                break;
            }
            default: {
                throw new RuntimeException("Error action name " + action.getName());
            }
        }
    }

    private void updateAggregationRule(Payload payload) {
        AggregationRule proto = payload.getRule();
        this.m_aggreationConfigManager.insertAggregationRule(proto);
    }
}

