/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.login;

import com.dianping.cat.system.SystemContext;
import com.dianping.cat.system.SystemPage;
import com.dianping.cat.system.page.login.Action;
import com.dianping.cat.system.page.login.Context;
import com.dianping.cat.system.page.login.JspViewer;
import com.dianping.cat.system.page.login.Model;
import com.dianping.cat.system.page.login.Payload;
import com.dianping.cat.system.page.login.service.Credential;
import com.dianping.cat.system.page.login.service.LoginMember;
import com.dianping.cat.system.page.login.service.Session;
import com.dianping.cat.system.page.login.service.SigninContext;
import com.dianping.cat.system.page.login.service.SigninService;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.unidal.lookup.annotation.Inject;
import org.unidal.web.jsp.function.CodecFunction;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.ErrorObject;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Handler
implements PageHandler<Context> {
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private SigninService m_signinService;

    private SigninContext createSigninContext(Context ctx) {
        return new SigninContext(ctx.getHttpServletRequest(), ctx.getHttpServletResponse());
    }

    /*
     * Enabled aggressive block sorting
     */
    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="login")
    public void handleInbound(Context ctx) throws ServletException, IOException {
        Payload payload = (Payload)ctx.getPayload();
        Action action = payload.getAction();
        if (payload.isSubmit() && action == Action.LOGIN) {
            String account = payload.getAccount();
            String password = payload.getPassword();
            if (account != null && account.length() != 0 && password != null) {
                Credential credential;
                SigninContext sc = this.createSigninContext(ctx);
                Session session = this.m_signinService.signin(sc, credential = new Credential(account, password));
                if (session != null) {
                    this.redirect(ctx, payload);
                    return;
                }
                ctx.addError(new ErrorObject("biz.login"));
            } else {
                ctx.addError(new ErrorObject("biz.login.input").addArgument("account", (Object)account).addArgument("password", (Object)password));
            }
        } else {
            if (action == Action.LOGOUT) {
                SigninContext sc = this.createSigninContext(ctx);
                this.m_signinService.signout(sc);
                this.redirect(ctx, payload);
                return;
            }
            SigninContext sc = this.createSigninContext(ctx);
            Session session = this.m_signinService.validate(sc);
            if (session != null) {
                ActionContext parent = ctx.getParent();
                if (parent instanceof SystemContext) {
                    SystemContext context = (SystemContext)parent;
                    LoginMember member = session.getMember();
                    context.setSigninMember(member);
                    this.logAccess(ctx, member);
                    return;
                }
                if (parent != null) {
                    throw new RuntimeException(String.format("%s should extend %s!", ctx.getClass(), SystemContext.class));
                }
            }
        }
        ctx.skipAction();
    }

    @OutboundActionMeta(name="login")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        model.setPage((Page)SystemPage.LOGIN);
        model.setAction((org.unidal.web.mvc.Action)Action.LOGIN);
        if (ctx.getParent() != null && (payload.getRtnUrl() == null || payload.getRtnUrl().length() == 0)) {
            HttpServletRequest request = ctx.getHttpServletRequest();
            String qs = request.getQueryString();
            String requestURI = request.getRequestURI();
            if (qs != null) {
                payload.setRtnUrl(requestURI + "?" + qs);
            } else {
                payload.setRtnUrl(requestURI);
            }
        }
        this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
    }

    private void logAccess(Context ctx, LoginMember member) {
        StringBuilder sb = new StringBuilder(256);
        SimpleDateFormat dateFormat = new SimpleDateFormat("[yyyy-MM-dd HH:mm:ss]");
        HttpServletRequest request = ctx.getHttpServletRequest();
        String actionUri = ctx.getRequestContext().getActionUri();
        sb.append(dateFormat.format(new Date()));
        if (request.getMethod().equalsIgnoreCase("post")) {
            Enumeration names = request.getParameterNames();
            boolean hasQuestion = actionUri.indexOf(63) >= 0;
            sb.append(actionUri);
            while (names.hasMoreElements()) {
                String[] attributes;
                String name = (String)names.nextElement();
                for (String attribute : attributes = request.getParameterValues(name)) {
                    if (attribute.length() <= 0) continue;
                    if (!hasQuestion) {
                        sb.append('?');
                        hasQuestion = true;
                    } else {
                        sb.append('&');
                    }
                    sb.append(name).append('=').append(CodecFunction.urlEncode((String)attribute));
                }
            }
        } else {
            sb.append(actionUri);
        }
    }

    private void redirect(Context ctx, Payload payload) {
        String url = payload.getRtnUrl();
        String loginUrl = ctx.getRequestContext().getActionUri(SystemPage.LOGIN.getName());
        if (url == null || url.length() == 0 || url.equals(loginUrl)) {
            url = ctx.getRequestContext().getActionUri("");
        }
        if (url.indexOf("/cat/s/login") > -1) {
            url = "/cat/r/home";
        }
        ctx.redirect(url);
        ctx.stopProcess();
    }
}

