/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.login.service;

import com.dianping.cat.system.page.login.service.Credential;
import com.dianping.cat.system.page.login.service.Session;
import com.dianping.cat.system.page.login.service.SessionManager;
import com.dianping.cat.system.page.login.service.SigninContext;
import com.dianping.cat.system.page.login.service.Token;
import com.dianping.cat.system.page.login.service.TokenManager;
import com.dianping.cat.system.page.login.spi.ISigninService;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SigninService
implements ISigninService<SigninContext, Credential, Session> {
    @Inject
    private TokenManager m_tokenManager;
    @Inject
    private SessionManager m_sessionManager;

    public Session signin(SigninContext ctx, Credential credential) {
        Token token = this.m_sessionManager.authenticate(credential);
        if (token != null) {
            Session session = this.m_sessionManager.validate(token);
            if (session != null) {
                this.m_tokenManager.setToken(ctx, token);
            }
            return session;
        }
        return null;
    }

    public void signout(SigninContext ctx) {
        this.m_tokenManager.removeToken(ctx, "ct");
    }

    public Session validate(SigninContext ctx) {
        Token token = this.m_tokenManager.getToken(ctx, "ct");
        if (token != null) {
            Session session = this.m_sessionManager.validate(token);
            return session;
        }
        return null;
    }
}

