/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.login.service;

import com.dianping.cat.system.page.login.service.SigninContext;
import com.dianping.cat.system.page.login.service.Token;
import com.dianping.cat.system.page.login.spi.ITokenBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenBuilder
implements ITokenBuilder<SigninContext, Token> {
    private static final String SP = "|";
    private static final long ONE_DAY = 86400000L;

    public String build(SigninContext ctx, Token token) {
        StringBuilder sb = new StringBuilder(256);
        String userName = token.getUserName();
        String userNameValue = "";
        try {
            userNameValue = URLEncoder.encode(userName, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String realName = token.getRealName();
        String value = "";
        try {
            value = URLEncoder.encode(realName, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        sb.append(value).append(SP);
        sb.append(userNameValue).append(SP);
        sb.append(System.currentTimeMillis()).append(SP);
        sb.append(ctx.getRequest().getRemoteAddr()).append(SP);
        sb.append(this.getCheckSum(sb.toString()));
        return sb.toString();
    }

    protected int getCheckSum(String str) {
        return str.hashCode();
    }

    public Token parse(SigninContext ctx, String value) {
        String[] parts = value.split(Pattern.quote(SP));
        if (parts.length == 5) {
            int expectedCheckSum;
            int checkSum;
            int index = 0;
            String realName = parts[index++];
            String userName = parts[index++];
            long lastLoginDate = Long.parseLong(parts[index++]);
            String remoteIp = parts[index++];
            if ((checkSum = Integer.parseInt(parts[index++])) == (expectedCheckSum = this.getCheckSum(value.substring(0, value.lastIndexOf(SP) + 1))) && remoteIp.equals(ctx.getRequest().getRemoteAddr()) && lastLoginDate + 86400000L > System.currentTimeMillis()) {
                return new Token(realName, userName);
            }
        }
        return null;
    }
}

