/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.plugin;

import com.dianping.cat.system.SystemPage;
import com.dianping.cat.system.page.plugin.Action;
import com.dianping.cat.system.page.plugin.Context;
import com.dianping.cat.system.page.plugin.JspViewer;
import com.dianping.cat.system.page.plugin.Model;
import com.dianping.cat.system.page.plugin.Payload;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.unidal.helper.Files;
import org.unidal.lookup.annotation.Inject;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Handler
implements PageHandler<Context> {
    @Inject
    private JspViewer m_jspViewer;
    private Map<String, String> m_serverMapping = new LinkedHashMap();

    public Handler() {
        this.m_serverMapping.put("10.1.6.37:8080", "cat.dianpingoa.com");
        this.m_serverMapping.put("10.1.8.64:8080", "cat.dianpingoa.com");
        this.m_serverMapping.put("10.1.6.102:8080", "cat.dianpingoa.com");
        this.m_serverMapping.put("10.1.6.108:8080", "cat.dianpingoa.com");
        this.m_serverMapping.put("10.1.6.126:8080", "cat.dianpingoa.com");
        this.m_serverMapping.put("10.1.6.128:8080", "cat.dianpingoa.com");
        this.m_serverMapping.put("10.1.6.145:8080", "cat.dianpingoa.com");
        this.m_serverMapping.put("192.168.7.70:8080", "cat.qa.dianpingoa.com");
    }

    private void addResourceFiles(ZipOutputStream zos, String baseDir, String ... paths) throws IOException {
        for (String path : paths) {
            ZipEntry entry = new ZipEntry(path);
            String resource = baseDir + "/" + path;
            byte[] data = Files.forIO().readFrom(this.getClass().getResourceAsStream(resource));
            zos.putNextEntry(entry);
            zos.write(data);
        }
    }

    private void downloadChromeExtension(Context ctx) throws IOException {
        Payload payload = (Payload)ctx.getPayload();
        HttpServletResponse res = ctx.getHttpServletResponse();
        if (payload.isDownloadMapping()) {
            StringBuilder sb = new StringBuilder(1024);
            boolean first = true;
            sb.append('{');
            for (Map.Entry e : this.m_serverMapping.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append('\"').append((String)e.getKey()).append("\":\"").append((String)e.getValue()).append('\"');
            }
            sb.append('}');
            byte[] content = sb.toString().getBytes("utf-8");
            res.setContentType("application/json; charset=utf-8");
            res.setContentLength(content.length);
            res.getOutputStream().write(content);
        } else if (payload.isDownloadSource()) {
            ZipOutputStream zos = new ZipOutputStream((OutputStream)res.getOutputStream());
            res.setContentType("application/x-zip-compressed");
            res.addHeader("Content-Disposition", "attachment;filename=cat.zip");
            this.addResourceFiles(zos, "/chrome/cat", new String[]{"manifest.json", "cat.png", "cat.js"});
            zos.close();
        } else {
            InputStream is = this.getClass().getResourceAsStream("/chrome/cat.crx");
            res.setContentType("application/octet-stream");
            res.addHeader("Content-Disposition", "attachment;filename=cat.crx");
            Files.forIO().copy(is, (OutputStream)res.getOutputStream(), Files.AutoClose.INPUT);
        }
        ctx.stopProcess();
    }

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="plugin")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="plugin")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        String type = payload.getType();
        model.setPage((Page)SystemPage.PLUGIN);
        model.setAction((org.unidal.web.mvc.Action)Action.VIEW);
        if ("chrome".equals(type)) {
            this.downloadChromeExtension(ctx);
        }
        if (!ctx.isProcessStopped()) {
            this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
        }
    }
}

