/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.router;

import com.dianping.cat.configuration.KVConfig;
import com.dianping.cat.helper.JsonBuilder;
import com.dianping.cat.home.router.entity.Domain;
import com.dianping.cat.home.router.entity.RouterConfig;
import com.dianping.cat.home.router.entity.Server;
import com.dianping.cat.system.page.router.Action;
import com.dianping.cat.system.page.router.Context;
import com.dianping.cat.system.page.router.Handler;
import com.dianping.cat.system.page.router.Model;
import com.dianping.cat.system.page.router.Payload;
import com.dianping.cat.system.page.router.config.RouterConfigManager;
import com.dianping.cat.system.page.router.service.RouterConfigService;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Handler
implements PageHandler<Context> {
    @Inject
    private RouterConfigService m_reportService;
    @Inject
    private RouterConfigManager m_configManager;

    private String buildRouterInfo(String domain, RouterConfig report) {
        Domain domainConfig = this.m_configManager.getRouterConfig().findDomain(domain);
        if (domainConfig == null || domainConfig.getServers().isEmpty()) {
            if (report != null) {
                Domain d = report.findDomain(domain);
                String str = null;
                if (d == null) {
                    this.m_configManager.getRouterConfig().getDefaultServers();
                    List servers = this.m_configManager.queryServersByDomain(domain);
                    str = this.buildServerStr(servers);
                } else {
                    List servers = d.getServers();
                    str = this.buildServerStr(servers);
                }
                return str;
            }
            List servers = this.m_configManager.queryServersByDomain(domain);
            return this.buildServerStr(servers);
        }
        return this.buildServerStr(domainConfig.getServers());
    }

    private String buildSampleInfo(String domain) {
        double sample = 1.0;
        Domain domainConfig = this.m_configManager.getRouterConfig().findDomain(domain);
        if (domainConfig != null) {
            sample = domainConfig.getSample();
        }
        return String.valueOf(sample);
    }

    private String buildServerStr(List<Server> servers) {
        StringBuilder sb = new StringBuilder();
        for (Server server : servers) {
            sb.append(server.getId()).append(":").append(server.getPort()).append(";");
        }
        return sb.toString();
    }

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="router")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="router")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        Action action = payload.getAction();
        Date start = payload.getDate();
        Date end = new Date(start.getTime() + 86400000L);
        RouterConfig report = (RouterConfig)this.m_reportService.queryReport("cat", start, end);
        String domain = payload.getDomain();
        switch (1.$SwitchMap$com$dianping$cat$system$page$router$Action[action.ordinal()]) {
            case 1: {
                String routerInfo = this.buildRouterInfo(domain, report);
                model.setContent(routerInfo);
                break;
            }
            case 2: {
                KVConfig config = new KVConfig();
                Map kvs = config.getKvs();
                kvs.put("routers", this.buildRouterInfo(domain, report));
                kvs.put("sample", this.buildSampleInfo(domain));
                model.setContent(new JsonBuilder().toJson((Object)config));
                break;
            }
            case 3: {
                if (report == null) break;
                model.setContent(report.toString());
            }
        }
        ctx.getHttpServletResponse().getWriter().write(model.getContent());
    }
}

