/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.router.config;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.state.model.entity.StateReport;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.DailyReportDao;
import com.dianping.cat.helper.SortHelper;
import com.dianping.cat.home.router.entity.Domain;
import com.dianping.cat.home.router.entity.RouterConfig;
import com.dianping.cat.home.router.entity.Server;
import com.dianping.cat.home.router.transform.DefaultNativeBuilder;
import com.dianping.cat.report.page.state.service.StateReportService;
import com.dianping.cat.system.page.router.config.RouterConfigHandler;
import com.dianping.cat.system.page.router.config.RouterConfigManager;
import com.dianping.cat.system.page.router.service.RouterConfigService;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.unidal.dal.jdbc.DalException;
import org.unidal.lookup.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterConfigHandler
implements LogEnabled {
    @Inject
    private StateReportService m_stateReportService;
    @Inject
    private RouterConfigManager m_configManager;
    @Inject
    private RouterConfigService m_reportService;
    @Inject
    private DailyReportDao m_dailyReportDao;
    protected Logger m_logger;

    public boolean updateRouterConfig(Date period) {
        try {
            String name = "router";
            String domain = "cat";
            RouterConfig routerConfig = this.buildRouterConfig(name, domain, period);
            DailyReport dailyReport = new DailyReport();
            dailyReport.setCreationDate(new Date());
            dailyReport.setDomain(domain);
            dailyReport.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
            dailyReport.setName(name);
            dailyReport.setPeriod(period);
            dailyReport.setType(1);
            this.m_dailyReportDao.deleteByDomainNamePeriod(dailyReport);
            byte[] binaryContent = DefaultNativeBuilder.build((RouterConfig)routerConfig);
            this.m_reportService.insertDailyReport(dailyReport, binaryContent);
            return true;
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    private void addServerList(List<Server> servers, Server server) {
        for (Server s : servers) {
            if (!s.getId().equals(server.getId())) continue;
            return;
        }
        servers.add(server);
    }

    public RouterConfig buildRouterConfig(String name, String domain, Date period) {
        Date end = new Date(period.getTime() + 86400000L);
        StateReport report = (StateReport)this.m_stateReportService.queryReport("cat", period, end);
        RouterConfig routerConfig = new RouterConfig("cat");
        StateReportVisitor visitor = new StateReportVisitor();
        visitor.visitStateReport(report);
        Map numbers = visitor.getNumbers();
        1 compator = new /* Unavailable Anonymous Inner Class!! */;
        numbers = SortHelper.sortMap((Map)numbers, (Comparator)compator);
        Map servers = this.findAvaliableServers();
        this.processMainServer(servers, routerConfig, numbers);
        for (Map.Entry entry : servers.entrySet()) {
            Cat.logEvent((String)"RouterConfig", (String)(((Server)entry.getKey()).getId() + ":" + entry.getValue()), (String)"0", null);
        }
        this.processBackServer(servers, routerConfig, numbers);
        routerConfig.setStartTime(period);
        routerConfig.setEndTime(end);
        return routerConfig;
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    private Map<Server, Long> findAvaliableServers() {
        List servers = this.m_configManager.queryEnableServers();
        HashMap<Server, Long> result = new HashMap<Server, Long>();
        for (Server server : servers) {
            result.put(server, 0L);
        }
        return result;
    }

    private Server findMinServer(Map<Server, Long> maps) {
        long min = Long.MAX_VALUE;
        Server result = null;
        for (Map.Entry<Server, Long> entry : maps.entrySet()) {
            Server server = entry.getKey();
            Long value = (long)((double)entry.getValue().longValue() / server.getWeight());
            if (value >= min) continue;
            result = entry.getKey();
            min = value;
        }
        return result;
    }

    private void processBackServer(Map<Server, Long> servers, RouterConfig routerConfig, Map<String, Long> numbers) {
        LinkedHashMap backServers = new LinkedHashMap();
        Server backUpServer = this.m_configManager.queryBackUpServer();
        Collection values = routerConfig.getDomains().values();
        for (Domain domain : values) {
            Server nextServer;
            List domainServers = domain.getServers();
            String domainName = domain.getId();
            Domain defaultDomainConfig = this.m_configManager.getRouterConfig().findDomain(domainName);
            if (defaultDomainConfig != null && !defaultDomainConfig.getServers().isEmpty()) continue;
            Server server = (Server)domain.getServers().get(0);
            LinkedHashMap<Server, Long> serverProcess = (LinkedHashMap<Server, Long>)backServers.get(server);
            if (serverProcess == null) {
                serverProcess = new LinkedHashMap<Server, Long>();
                for (Map.Entry<Server, Long> entry : servers.entrySet()) {
                    if (entry.getKey().equals((Object)server)) continue;
                    serverProcess.put(entry.getKey(), entry.getValue());
                }
                backServers.put(server, serverProcess);
            }
            if ((nextServer = this.findMinServer((Map)serverProcess)) != null) {
                Long oldValue = (Long)serverProcess.get(nextServer);
                serverProcess.put(nextServer, oldValue + numbers.get(domain.getId()));
                this.addServerList(domainServers, nextServer);
            }
            this.addServerList(domainServers, backUpServer);
        }
    }

    private void processMainServer(Map<Server, Long> servers, RouterConfig routerConfig, Map<String, Long> numbers) {
        for (Map.Entry<String, Long> entry : numbers.entrySet()) {
            Long oldValue;
            Server server;
            String domainName = entry.getKey();
            Domain defaultDomainConfig = this.m_configManager.getRouterConfig().findDomain(domainName);
            Long value = entry.getValue();
            if (defaultDomainConfig == null || defaultDomainConfig.getServers().isEmpty()) {
                server = this.findMinServer(servers);
                oldValue = servers.get(server);
                Domain domainConfig = new Domain(domainName);
                servers.put(server, oldValue + value);
                domainConfig.addServer(server);
                routerConfig.addDomain(domainConfig);
                continue;
            }
            routerConfig.addDomain(defaultDomainConfig);
            server = (Server)defaultDomainConfig.getServers().get(0);
            oldValue = servers.get(server);
            if (oldValue == null) continue;
            servers.put(server, oldValue + value);
        }
    }
}

