/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.router.config;

import com.dianping.cat.Cat;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigDao;
import com.dianping.cat.core.config.ConfigEntity;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.DailyReportContent;
import com.dianping.cat.core.dal.DailyReportContentDao;
import com.dianping.cat.core.dal.DailyReportContentEntity;
import com.dianping.cat.core.dal.DailyReportDao;
import com.dianping.cat.core.dal.DailyReportEntity;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.home.router.entity.DefaultServer;
import com.dianping.cat.home.router.entity.Domain;
import com.dianping.cat.home.router.entity.RouterConfig;
import com.dianping.cat.home.router.entity.Server;
import com.dianping.cat.home.router.transform.DefaultNativeParser;
import com.dianping.cat.home.router.transform.DefaultSaxParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.tuple.Pair;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterConfigManager
implements Initializable,
LogEnabled {
    @Inject
    private ConfigDao m_configDao;
    @Inject
    private ContentFetcher m_fetcher;
    @Inject
    private DailyReportDao m_dailyReportDao;
    @Inject
    private DailyReportContentDao m_dailyReportContentDao;
    private int m_configId;
    private volatile RouterConfig m_routerConfig;
    private Logger m_logger;
    private long m_modifyTime;
    private static final String CONFIG_NAME = "routerConfig";
    private Map<Long, Pair<RouterConfig, Long>> m_routerConfigs = new /* Unavailable Anonymous Inner Class!! */;

    private void addServerList(List<Server> servers, Server server) {
        for (Server s : servers) {
            if (!s.getId().equals(server.getId())) continue;
            return;
        }
        servers.add(server);
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public RouterConfig getRouterConfig() {
        return this.m_routerConfig;
    }

    public Map<Long, Pair<RouterConfig, Long>> getRouterConfigs() {
        return this.m_routerConfigs;
    }

    public void initialize() throws InitializationException {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_configId = config.getId();
            this.m_routerConfig = DefaultSaxParser.parse((String)content);
            this.m_modifyTime = config.getModifyDate().getTime();
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(CONFIG_NAME);
                Config config = this.m_configDao.createLocal();
                Date now = new Date();
                config.setName(CONFIG_NAME);
                config.setContent(content);
                config.setModifyDate(now);
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
                this.m_routerConfig = DefaultSaxParser.parse((String)content);
                this.m_modifyTime = now.getTime();
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        if (this.m_routerConfig == null) {
            this.m_routerConfig = new RouterConfig();
        }
    }

    public boolean insert(String xml) {
        try {
            this.m_routerConfig = DefaultSaxParser.parse((String)xml);
            boolean result = this.storeConfig();
            return result;
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            this.m_logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public Server queryBackUpServer() {
        return new Server().setId(this.m_routerConfig.getBackupServer()).setPort(this.m_routerConfig.getBackupServerPort());
    }

    public List<Server> queryEnableServers() {
        List servers = this.m_routerConfig.getDefaultServers();
        ArrayList<Server> result = new ArrayList<Server>();
        for (DefaultServer server : servers) {
            if (!server.isEnable()) continue;
            result.add(new Server().setId(server.getId()).setPort(server.getPort()).setWeight(server.getWeight()));
        }
        return result;
    }

    public List<Server> queryServersByDomain(String domain) {
        Domain domainConfig = this.m_routerConfig.findDomain(domain);
        ArrayList<Server> result = new ArrayList<Server>();
        if (domainConfig == null || domainConfig.getServers().isEmpty()) {
            List servers = this.queryEnableServers();
            int length = servers.size();
            int hashCode = domain.hashCode();
            if (length > 0) {
                for (int i = 0; i < 2; ++i) {
                    int index = Math.abs(hashCode + i) % length;
                    this.addServerList(result, (Server)servers.get(index));
                }
            }
            this.addServerList(result, this.queryBackUpServer());
        } else {
            for (Server server : domainConfig.getServers()) {
                result.add(server);
            }
        }
        return result;
    }

    public void refreshConfig() throws Exception {
        this.refreshConfigInfo();
        this.refreshReportInfo();
    }

    private void refreshReportInfo() throws Exception {
        block6: {
            Date period = TimeHelper.getCurrentDay((int)-1);
            long time = period.getTime();
            try {
                DailyReport report = this.m_dailyReportDao.findByDomainNamePeriod("cat", "router", period, DailyReportEntity.READSET_FULL);
                long modifyTime = report.getCreationDate().getTime();
                Pair pair = (Pair)this.m_routerConfigs.get(time);
                if (pair != null && modifyTime <= (Long)pair.getValue()) break block6;
                try {
                    DailyReportContent reportContent = this.m_dailyReportContentDao.findByPK(report.getId(), DailyReportContentEntity.READSET_FULL);
                    RouterConfig routerConfig = DefaultNativeParser.parse((byte[])reportContent.getContent());
                    this.m_routerConfigs.put(time, new Pair((Object)routerConfig, (Object)modifyTime));
                    Cat.logEvent((String)"ReloadConfig", (String)"router");
                }
                catch (DalNotFoundException reportContent) {
                }
                catch (Exception e) {
                    throw e;
                }
            }
            catch (DalNotFoundException report) {
            }
            catch (Exception e) {
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshConfigInfo() throws DalException, SAXException, IOException {
        Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
        long modifyTime = config.getModifyDate().getTime();
        RouterConfigManager routerConfigManager = this;
        synchronized (routerConfigManager) {
            if (modifyTime > this.m_modifyTime) {
                RouterConfig routerConfig;
                String content = config.getContent();
                this.m_routerConfig = routerConfig = DefaultSaxParser.parse((String)content);
                this.m_modifyTime = modifyTime;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeConfig() {
        RouterConfigManager routerConfigManager = this;
        synchronized (routerConfigManager) {
            try {
                Config config = this.m_configDao.createLocal();
                config.setId(this.m_configId);
                config.setKeyId(this.m_configId);
                config.setName(CONFIG_NAME);
                config.setContent(this.m_routerConfig.toString());
                this.m_configDao.updateByPK(config, ConfigEntity.UPDATESET_FULL);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
                return false;
            }
        }
        return true;
    }
}

