/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.router.service;

import com.dianping.cat.Cat;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.DailyReportContent;
import com.dianping.cat.core.dal.DailyReportContentEntity;
import com.dianping.cat.core.dal.DailyReportEntity;
import com.dianping.cat.home.router.entity.RouterConfig;
import com.dianping.cat.home.router.transform.DefaultNativeParser;
import com.dianping.cat.report.service.AbstractReportService;
import com.dianping.cat.system.page.router.config.RouterConfigManager;
import java.util.Date;
import java.util.Map;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.tuple.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterConfigService
extends AbstractReportService<RouterConfig> {
    @Inject
    private RouterConfigManager m_routerConfigManager;

    public RouterConfig makeReport(String domain, Date start, Date end) {
        return null;
    }

    public RouterConfig queryDailyReport(String domain, Date start, Date end) {
        long time = start.getTime();
        Map routerConfigs = this.m_routerConfigManager.getRouterConfigs();
        Pair pair = (Pair)routerConfigs.get(time);
        if (pair == null) {
            String name = "router";
            try {
                DailyReport report = this.m_dailyReportDao.findByDomainNamePeriod(domain, name, start, DailyReportEntity.READSET_FULL);
                RouterConfig config = this.queryFromDailyBinary(report.getId());
                routerConfigs.put(time, new Pair((Object)config, (Object)report.getCreationDate().getTime()));
                return config;
            }
            catch (DalNotFoundException report) {
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
            return null;
        }
        return (RouterConfig)pair.getKey();
    }

    private RouterConfig queryFromDailyBinary(int id) throws DalException {
        DailyReportContent content = this.m_dailyReportContentDao.findByPK(id, DailyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return null;
    }

    public RouterConfig queryHourlyReport(String domain, Date start, Date end) {
        throw new RuntimeException("router report don't support hourly report");
    }

    public RouterConfig queryMonthlyReport(String domain, Date start) {
        throw new RuntimeException("router report don't support monthly report");
    }

    public RouterConfig queryWeeklyReport(String domain, Date start) {
        throw new RuntimeException("router report don't support weekly report");
    }
}

