/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.router.task;

import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.home.router.entity.RouterConfig;
import com.dianping.cat.home.router.transform.DefaultNativeBuilder;
import com.dianping.cat.report.task.TaskBuilder;
import com.dianping.cat.system.page.router.config.RouterConfigHandler;
import com.dianping.cat.system.page.router.service.RouterConfigService;
import java.util.Date;
import org.unidal.lookup.annotation.Inject;

public class RouterConfigBuilder
implements TaskBuilder {
    public static final String ID = "router";
    @Inject
    private RouterConfigHandler m_routerConfigHandler;
    @Inject
    private RouterConfigService m_reportService;

    public boolean buildDailyTask(String name, String domain, Date period) {
        RouterConfig routerConfig = this.m_routerConfigHandler.buildRouterConfig(name, domain, period);
        DailyReport dailyReport = new DailyReport();
        dailyReport.setCreationDate(new Date());
        dailyReport.setDomain(domain);
        dailyReport.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        dailyReport.setName(name);
        dailyReport.setPeriod(period);
        dailyReport.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((RouterConfig)routerConfig);
        this.m_reportService.insertDailyReport(dailyReport, binaryContent);
        return true;
    }

    public boolean buildHourlyTask(String name, String domain, Date period) {
        throw new RuntimeException("router builder don't support hourly task");
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        throw new RuntimeException("router builder don't support monthly task");
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        throw new RuntimeException("router builder don't support weekly task");
    }
}

