/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.alert.summary.entity;

import com.dianping.cat.home.alert.summary.BaseEntity;
import com.dianping.cat.home.alert.summary.IVisitor;
import com.dianping.cat.home.alert.summary.entity.Category;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class AlertSummary
extends BaseEntity<AlertSummary> {
    private Date m_alertDate;
    private String m_domain;
    private Map<String, Category> m_categories = new LinkedHashMap();

    public void accept(IVisitor visitor) {
        visitor.visitAlertSummary(this);
    }

    public AlertSummary addCategory(Category category) {
        this.m_categories.put(category.getName(), category);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AlertSummary) {
            AlertSummary _o = (AlertSummary)obj;
            if (!this.equals((Object)this.getAlertDate(), (Object)_o.getAlertDate())) {
                return false;
            }
            if (!this.equals((Object)this.getDomain(), (Object)_o.getDomain())) {
                return false;
            }
            return this.equals((Object)this.getCategories(), (Object)_o.getCategories());
        }
        return false;
    }

    public Category findCategory(String name) {
        return (Category)this.m_categories.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Category findOrCreateCategory(String name) {
        Category category = (Category)this.m_categories.get(name);
        if (category == null) {
            Map map = this.m_categories;
            synchronized (map) {
                category = (Category)this.m_categories.get(name);
                if (category == null) {
                    category = new Category(name);
                    this.m_categories.put(name, category);
                }
            }
        }
        return category;
    }

    public Date getAlertDate() {
        return this.m_alertDate;
    }

    public Map<String, Category> getCategories() {
        return this.m_categories;
    }

    public String getDomain() {
        return this.m_domain;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_alertDate == null ? 0 : this.m_alertDate.hashCode());
        hash = hash * 31 + (this.m_domain == null ? 0 : this.m_domain.hashCode());
        hash = hash * 31 + (this.m_categories == null ? 0 : this.m_categories.hashCode());
        return hash;
    }

    public void mergeAttributes(AlertSummary other) {
        if (other.getAlertDate() != null) {
            this.m_alertDate = other.getAlertDate();
        }
        if (other.getDomain() != null) {
            this.m_domain = other.getDomain();
        }
    }

    public Category removeCategory(String name) {
        return (Category)this.m_categories.remove(name);
    }

    public AlertSummary setAlertDate(Date alertDate) {
        this.m_alertDate = alertDate;
        return this;
    }

    public AlertSummary setDomain(String domain) {
        this.m_domain = domain;
        return this;
    }
}

