/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.alert.summary.transform;

import com.dianping.cat.home.alert.summary.entity.Alert;
import com.dianping.cat.home.alert.summary.entity.AlertSummary;
import com.dianping.cat.home.alert.summary.entity.Category;
import com.dianping.cat.home.alert.summary.transform.IMaker;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultDomMaker
implements IMaker<Node> {
    public Alert buildAlert(Node node) {
        String alertTime = this.getAttribute(node, "alertTime");
        String type = this.getAttribute(node, "type");
        String metric = this.getAttribute(node, "metric");
        String context = this.getAttribute(node, "context");
        String domain = this.getAttribute(node, "domain");
        String count = this.getAttribute(node, "count");
        Alert alert = new Alert();
        if (alertTime != null) {
            alert.setAlertTime(this.toDate(alertTime, "yyyy-MM-dd HH:mm:ss", null));
        }
        if (type != null) {
            alert.setType(type);
        }
        if (metric != null) {
            alert.setMetric(metric);
        }
        if (context != null) {
            alert.setContext(context);
        }
        if (domain != null) {
            alert.setDomain(domain);
        }
        if (count != null) {
            alert.setCount((Integer)this.convert(Integer.class, count, null));
        }
        return alert;
    }

    public AlertSummary buildAlertSummary(Node node) {
        String alertDate = this.getAttribute(node, "alert-date");
        String domain = this.getAttribute(node, "domain");
        AlertSummary alertSummary = new AlertSummary();
        if (alertDate != null) {
            alertSummary.setAlertDate(this.toDate(alertDate, "yyyy-MM-dd HH:mm:ss", null));
        }
        if (domain != null) {
            alertSummary.setDomain(domain);
        }
        return alertSummary;
    }

    public Category buildCategory(Node node) {
        String name = this.getAttribute(node, "name");
        Category category = new Category(name);
        return category;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class || type == Short.TYPE) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class || type == Character.TYPE) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    protected String getAttribute(Node node, String name) {
        Node attribute = node.getAttributes().getNamedItem(name);
        return attribute == null ? null : attribute.getNodeValue();
    }

    protected Node getChildTagNode(Node parent, String name) {
        NodeList children = parent.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals(name)) continue;
            return child;
        }
        return null;
    }

    protected Date toDate(String str, String format, Date defaultValue) {
        if (str == null || str.length() == 0) {
            return defaultValue;
        }
        try {
            return new SimpleDateFormat(format).parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Unable to parse date(%s) in format(%s)!", str, format), e);
        }
    }
}

