/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.alert.summary.transform;

import com.dianping.cat.home.alert.summary.entity.Alert;
import com.dianping.cat.home.alert.summary.entity.AlertSummary;
import com.dianping.cat.home.alert.summary.entity.Category;
import com.dianping.cat.home.alert.summary.transform.DefaultDomMaker;
import com.dianping.cat.home.alert.summary.transform.DefaultLinker;
import com.dianping.cat.home.alert.summary.transform.ILinker;
import com.dianping.cat.home.alert.summary.transform.IMaker;
import com.dianping.cat.home.alert.summary.transform.IParser;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultDomParser
implements IParser<Node> {
    protected Node getChildTagNode(Node parent, String name) {
        NodeList children = parent.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals(name)) continue;
            return child;
        }
        return null;
    }

    protected List<Node> getChildTagNodes(Node parent, String name) {
        NodeList children = parent.getChildNodes();
        int len = children.getLength();
        ArrayList<Node> nodes = new ArrayList<Node>(len);
        for (int i = 0; i < len; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || name != null && !child.getNodeName().equals(name)) continue;
            nodes.add(child);
        }
        return nodes;
    }

    protected Node getDocument(String xml) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setIgnoringComments(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    protected List<Node> getGrandChildTagNodes(Node parent, String name) {
        Node child = this.getChildTagNode(parent, name);
        NodeList children = child == null ? null : child.getChildNodes();
        int len = children == null ? 0 : children.getLength();
        ArrayList<Node> nodes = new ArrayList<Node>(len);
        for (int i = 0; i < len; ++i) {
            Node grandChild = children.item(i);
            if (grandChild.getNodeType() != 1) continue;
            nodes.add(grandChild);
        }
        return nodes;
    }

    public AlertSummary parse(Node node) {
        return this.parse((IMaker)new DefaultDomMaker(), (ILinker)new DefaultLinker(false), node);
    }

    public AlertSummary parse(String xml) throws SAXException, IOException {
        Node doc = this.getDocument(xml);
        Node rootNode = this.getChildTagNode(doc, "alert-summary");
        if (rootNode == null) {
            throw new RuntimeException(String.format("alert-summary element(%s) is expected!", "alert-summary"));
        }
        return this.parse((IMaker)new DefaultDomMaker(), (ILinker)new DefaultLinker(false), rootNode);
    }

    public AlertSummary parse(IMaker<Node> maker, ILinker linker, Node node) {
        AlertSummary alertSummary = maker.buildAlertSummary((Object)node);
        if (node != null) {
            AlertSummary parent = alertSummary;
            for (Node child : this.getChildTagNodes(node, "category")) {
                Category category = maker.buildCategory((Object)child);
                if (!linker.onCategory(parent, category)) continue;
                this.parseForCategory(maker, linker, category, child);
            }
        }
        return alertSummary;
    }

    public void parseForAlert(IMaker<Node> maker, ILinker linker, Alert parent, Node node) {
    }

    public void parseForCategory(IMaker<Node> maker, ILinker linker, Category parent, Node node) {
        for (Node child : this.getChildTagNodes(node, "alert")) {
            Alert alert = maker.buildAlert((Object)child);
            if (!linker.onAlert(parent, alert)) continue;
            this.parseForAlert(maker, linker, alert, child);
        }
    }
}

