/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.dependency.config.entity;

import com.dianping.cat.home.dependency.config.BaseEntity;
import com.dianping.cat.home.dependency.config.IVisitor;

public class DomainConfig
extends BaseEntity<DomainConfig> {
    private String m_id;
    private int m_warningThreshold;
    private int m_errorThreshold;
    private double m_warningResponseTime;
    private double m_errorResponseTime;
    private int m_minCountThreshold = 100;

    public DomainConfig() {
    }

    public DomainConfig(String id) {
        this.m_id = id;
    }

    public void accept(IVisitor visitor) {
        visitor.visitDomainConfig(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DomainConfig) {
            DomainConfig _o = (DomainConfig)obj;
            return this.equals((Object)this.getId(), (Object)_o.getId());
        }
        return false;
    }

    public double getErrorResponseTime() {
        return this.m_errorResponseTime;
    }

    public int getErrorThreshold() {
        return this.m_errorThreshold;
    }

    public String getId() {
        return this.m_id;
    }

    public int getMinCountThreshold() {
        return this.m_minCountThreshold;
    }

    public double getWarningResponseTime() {
        return this.m_warningResponseTime;
    }

    public int getWarningThreshold() {
        return this.m_warningThreshold;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    public void mergeAttributes(DomainConfig other) {
        this.assertAttributeEquals((Object)other, "domain-config", "id", (Object)this.m_id, (Object)other.getId());
        this.m_warningThreshold = other.getWarningThreshold();
        this.m_errorThreshold = other.getErrorThreshold();
        this.m_warningResponseTime = other.getWarningResponseTime();
        this.m_errorResponseTime = other.getErrorResponseTime();
        this.m_minCountThreshold = other.getMinCountThreshold();
    }

    public DomainConfig setErrorResponseTime(double errorResponseTime) {
        this.m_errorResponseTime = errorResponseTime;
        return this;
    }

    public DomainConfig setErrorThreshold(int errorThreshold) {
        this.m_errorThreshold = errorThreshold;
        return this;
    }

    public DomainConfig setId(String id) {
        this.m_id = id;
        return this;
    }

    public DomainConfig setMinCountThreshold(int minCountThreshold) {
        this.m_minCountThreshold = minCountThreshold;
        return this;
    }

    public DomainConfig setWarningResponseTime(double warningResponseTime) {
        this.m_warningResponseTime = warningResponseTime;
        return this;
    }

    public DomainConfig setWarningThreshold(int warningThreshold) {
        this.m_warningThreshold = warningThreshold;
        return this;
    }
}

