/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.dependency.config.transform;

import com.dianping.cat.home.dependency.config.IEntity;
import com.dianping.cat.home.dependency.config.IVisitor;
import com.dianping.cat.home.dependency.config.entity.DomainConfig;
import com.dianping.cat.home.dependency.config.entity.EdgeConfig;
import com.dianping.cat.home.dependency.config.entity.NodeConfig;
import com.dianping.cat.home.dependency.config.entity.TopologyGraphConfig;
import java.util.Stack;

public class DefaultMerger
implements IVisitor {
    private Stack<Object> m_objs = new Stack();
    private TopologyGraphConfig m_topologyGraphConfig;

    public DefaultMerger() {
    }

    public DefaultMerger(TopologyGraphConfig topologyGraphConfig) {
        this.m_topologyGraphConfig = topologyGraphConfig;
        this.m_objs.push(topologyGraphConfig);
    }

    public TopologyGraphConfig getTopologyGraphConfig() {
        return this.m_topologyGraphConfig;
    }

    protected Stack<Object> getObjects() {
        return this.m_objs;
    }

    public <T> void merge(IEntity<T> to, IEntity<T> from) {
        this.m_objs.push(to);
        from.accept((IVisitor)this);
        this.m_objs.pop();
    }

    protected void mergeDomainConfig(DomainConfig to, DomainConfig from) {
        to.mergeAttributes(from);
    }

    protected void mergeEdgeConfig(EdgeConfig to, EdgeConfig from) {
        to.mergeAttributes(from);
    }

    protected void mergeNodeConfig(NodeConfig to, NodeConfig from) {
        to.mergeAttributes(from);
    }

    protected void mergeTopologyGraphConfig(TopologyGraphConfig to, TopologyGraphConfig from) {
        to.mergeAttributes(from);
    }

    public void visitDomainConfig(DomainConfig from) {
        DomainConfig to = (DomainConfig)this.m_objs.peek();
        this.mergeDomainConfig(to, from);
        this.visitDomainConfigChildren(to, from);
    }

    protected void visitDomainConfigChildren(DomainConfig to, DomainConfig from) {
    }

    public void visitEdgeConfig(EdgeConfig from) {
        EdgeConfig to = (EdgeConfig)this.m_objs.peek();
        this.mergeEdgeConfig(to, from);
        this.visitEdgeConfigChildren(to, from);
    }

    protected void visitEdgeConfigChildren(EdgeConfig to, EdgeConfig from) {
    }

    public void visitNodeConfig(NodeConfig from) {
        NodeConfig to = (NodeConfig)this.m_objs.peek();
        this.mergeNodeConfig(to, from);
        this.visitNodeConfigChildren(to, from);
    }

    protected void visitNodeConfigChildren(NodeConfig to, NodeConfig from) {
        for (DomainConfig source : from.getDomainConfigs().values()) {
            DomainConfig target = to.findDomainConfig(source.getId());
            if (target == null) {
                target = new DomainConfig(source.getId());
                to.addDomainConfig(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }

    public void visitTopologyGraphConfig(TopologyGraphConfig from) {
        TopologyGraphConfig to = (TopologyGraphConfig)this.m_objs.peek();
        this.mergeTopologyGraphConfig(to, from);
        this.visitTopologyGraphConfigChildren(to, from);
    }

    protected void visitTopologyGraphConfigChildren(TopologyGraphConfig to, TopologyGraphConfig from) {
        NodeConfig target;
        for (NodeConfig source : from.getNodeConfigs().values()) {
            target = to.findNodeConfig(source.getType());
            if (target == null) {
                target = new NodeConfig(source.getType());
                to.addNodeConfig(target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
        for (NodeConfig source : from.getEdgeConfigs().values()) {
            target = to.findEdgeConfig(source.getKey());
            if (target == null) {
                target = new EdgeConfig(source.getKey());
                to.addEdgeConfig((EdgeConfig)target);
            }
            this.m_objs.push(target);
            source.accept((IVisitor)this);
            this.m_objs.pop();
        }
    }
}

