/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.dependency.format.transform;

import com.dianping.cat.home.dependency.format.IEntity;
import com.dianping.cat.home.dependency.format.IVisitor;
import com.dianping.cat.home.dependency.format.entity.Domain;
import com.dianping.cat.home.dependency.format.entity.ProductLine;
import com.dianping.cat.home.dependency.format.entity.TopoGraphFormatConfig;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public class DefaultXmlBuilder
implements IVisitor {
    private IVisitor m_visitor = this;
    private int m_level;
    private StringBuilder m_sb;
    private boolean m_compact;

    public DefaultXmlBuilder() {
        this(false);
    }

    public DefaultXmlBuilder(boolean compact) {
        this(compact, new StringBuilder(4096));
    }

    public DefaultXmlBuilder(boolean compact, StringBuilder sb) {
        this.m_compact = compact;
        this.m_sb = sb;
        this.m_sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
    }

    public String buildXml(IEntity<?> entity) {
        entity.accept(this.m_visitor);
        return this.m_sb.toString();
    }

    protected void endTag(String name) {
        --this.m_level;
        this.indent();
        this.m_sb.append("</").append(name).append(">\r\n");
    }

    protected String escape(Object value) {
        return this.escape(value, false);
    }

    protected String escape(Object value, boolean text) {
        if (value == null) {
            return null;
        }
        String str = this.toString(value);
        int len = str.length();
        StringBuilder sb = new StringBuilder(len + 16);
        block6: for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    if (!text) {
                        sb.append("&quot;");
                        continue block6;
                    }
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    protected void indent() {
        if (!this.m_compact) {
            for (int i = this.m_level - 1; i >= 0; --i) {
                this.m_sb.append("   ");
            }
        }
    }

    protected void startTag(String name) {
        this.startTag(name, false, null, new Object[0]);
    }

    protected void startTag(String name, boolean closed, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.startTag(name, null, closed, dynamicAttributes, nameValues);
    }

    protected void startTag(String name, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.startTag(name, null, false, dynamicAttributes, nameValues);
    }

    protected void startTag(String name, Object text, boolean closed, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.indent();
        this.m_sb.append('<').append(name);
        int len = nameValues.length;
        int i = 0;
        while (i + 1 < len) {
            Object attrName = nameValues[i];
            Object attrValue = nameValues[i + 1];
            if (attrValue != null) {
                this.m_sb.append(' ').append(attrName).append("=\"").append(this.escape(attrValue)).append('\"');
            }
            i += 2;
        }
        if (dynamicAttributes != null) {
            for (Map.Entry<String, String> e : dynamicAttributes.entrySet()) {
                this.m_sb.append(' ').append(e.getKey()).append("=\"").append(this.escape((Object)e.getValue())).append('\"');
            }
        }
        if (text != null && closed) {
            this.m_sb.append('>');
            this.m_sb.append(this.escape(text, true));
            this.m_sb.append("</").append(name).append(">\r\n");
        } else {
            if (closed) {
                this.m_sb.append('/');
            } else {
                ++this.m_level;
            }
            this.m_sb.append(">\r\n");
        }
    }

    protected String toString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Collection) {
            Collection list = (Collection)value;
            StringBuilder sb = new StringBuilder(32);
            boolean first = true;
            for (Object item : list) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                if (item == null) continue;
                sb.append(item);
            }
            return sb.toString();
        }
        if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            StringBuilder sb = new StringBuilder(32);
            boolean first = true;
            for (int i = 0; i < len; ++i) {
                Object item = Array.get(value, i);
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                if (item == null) continue;
                sb.append(item);
            }
            return sb.toString();
        }
        return String.valueOf(value);
    }

    public void visitDomain(Domain domain) {
        this.startTag("domain", true, null, new Object[]{"id", domain.getId(), "colInside", domain.getColInside()});
    }

    public void visitProductLine(ProductLine productLine) {
        this.startTag("productLine", null, new Object[]{"id", productLine.getId(), "colInside", productLine.getColInside()});
        if (!productLine.getDomains().isEmpty()) {
            for (Domain domain : productLine.getDomains()) {
                domain.accept(this.m_visitor);
            }
        }
        this.endTag("productLine");
    }

    public void visitTopoGraphFormatConfig(TopoGraphFormatConfig topoGraphFormatConfig) {
        this.startTag("topoGraph-format-config", null, new Object[0]);
        if (!topoGraphFormatConfig.getProductLines().isEmpty()) {
            for (ProductLine productLine : topoGraphFormatConfig.getProductLines()) {
                productLine.accept(this.m_visitor);
            }
        }
        this.endTag("topoGraph-format-config");
    }
}

