/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.dependency.graph;

import com.dianping.cat.home.dependency.graph.IEntity;
import com.dianping.cat.home.dependency.graph.transform.DefaultJsonBuilder;
import com.dianping.cat.home.dependency.graph.transform.DefaultXmlBuilder;
import java.util.Formattable;
import java.util.Formatter;

public abstract class BaseEntity<T>
implements IEntity<T>,
Formattable {
    public static final String JSON = "%#.3s";
    public static final String JSON_COMPACT = "%#s";
    public static final String XML = "%.3s";
    public static final String XML_COMPACT = "%s";

    protected void assertAttributeEquals(Object instance, String entityName, String name, Object expectedValue, Object actualValue) {
        if (expectedValue == null && actualValue != null || expectedValue != null && !expectedValue.equals(actualValue)) {
            throw new IllegalArgumentException(String.format("Mismatched entity(%s) found! Same %s attribute is expected! %s: %s.", entityName, name, entityName, instance));
        }
    }

    protected boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        boolean compact;
        boolean useJson = (flags & 4) == 4;
        boolean bl = compact = precision <= 0;
        if (useJson) {
            DefaultJsonBuilder builder = new DefaultJsonBuilder(compact);
            formatter.format(XML_COMPACT, builder.build((IEntity)this));
        } else {
            DefaultXmlBuilder builder = new DefaultXmlBuilder(compact);
            formatter.format(XML_COMPACT, builder.buildXml((IEntity)this));
        }
    }

    public String toString() {
        return new DefaultXmlBuilder().buildXml((IEntity)this);
    }
}

