/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.dependency.graph.transform;

import com.dianping.cat.home.dependency.graph.IEntity;
import com.dianping.cat.home.dependency.graph.entity.TopologyEdge;
import com.dianping.cat.home.dependency.graph.entity.TopologyGraph;
import com.dianping.cat.home.dependency.graph.entity.TopologyNode;
import com.dianping.cat.home.dependency.graph.transform.DefaultLinker;
import com.dianping.cat.home.dependency.graph.transform.DefaultSaxMaker;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultSaxParser
extends DefaultHandler {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DefaultSaxMaker m_maker = new DefaultSaxMaker();
    private Stack<String> m_tags = new Stack();
    private Stack<Object> m_objs = new Stack();
    private IEntity<?> m_entity;
    private StringBuilder m_text = new StringBuilder();

    public static TopologyGraph parse(InputStream in) throws SAXException, IOException {
        return (TopologyGraph)DefaultSaxParser.parseEntity(TopologyGraph.class, (InputSource)new InputSource((InputStream)DefaultSaxParser.removeBOM((Object)in)));
    }

    public static TopologyGraph parse(Reader reader) throws SAXException, IOException {
        return (TopologyGraph)DefaultSaxParser.parseEntity(TopologyGraph.class, (InputSource)new InputSource((Reader)DefaultSaxParser.removeBOM((Object)reader)));
    }

    public static TopologyGraph parse(String xml) throws SAXException, IOException {
        return (TopologyGraph)DefaultSaxParser.parseEntity(TopologyGraph.class, (InputSource)new InputSource(new StringReader((String)DefaultSaxParser.removeBOM((Object)xml))));
    }

    private static <T extends IEntity<?>> T parseEntity(Class<T> type, InputSource is) throws SAXException, IOException {
        try {
            DefaultSaxParser handler = new DefaultSaxParser();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.newSAXParser().parse(is, (DefaultHandler)handler);
            return (T)handler.getEntity();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to get SAX parser instance!", e);
        }
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, InputStream in) throws SAXException, IOException {
        return (T)DefaultSaxParser.parseEntity(type, (InputSource)new InputSource((InputStream)DefaultSaxParser.removeBOM((Object)in)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, String xml) throws SAXException, IOException {
        return (T)DefaultSaxParser.parseEntity(type, (InputSource)new InputSource(new StringReader((String)DefaultSaxParser.removeBOM((Object)xml))));
    }

    private static <T> T removeBOM(T obj) throws IOException {
        if (obj instanceof String) {
            String str = (String)obj;
            if (str.length() != 0 && str.charAt(0) == '\ufeff') {
                return (T)str.substring(1);
            }
            return obj;
        }
        if (obj instanceof InputStream) {
            BufferedInputStream in = new BufferedInputStream((InputStream)obj);
            in.mark(3);
            if (in.read() != 239 || in.read() != 187 || in.read() != 191) {
                in.reset();
            }
            return (T)in;
        }
        if (obj instanceof Reader) {
            BufferedReader in = new BufferedReader((Reader)obj);
            in.mark(1);
            if (in.read() != 65279) {
                in.reset();
            }
            return (T)in;
        }
        return obj;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_text.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.m_linker.finish();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri == null || uri.length() == 0) {
            this.m_objs.pop();
            this.m_tags.pop();
        }
        this.m_text.setLength(0);
    }

    private IEntity<?> getEntity() {
        return this.m_entity;
    }

    protected String getText() {
        return this.m_text.toString();
    }

    private void parseForTopologyEdge(TopologyEdge parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForTopologyGraph(TopologyGraph parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("topology-node".equals(qName)) {
            TopologyNode topologyNode = this.m_maker.buildTopologyNode(attributes);
            this.m_linker.onTopologyNode(parentObj, topologyNode);
            this.m_objs.push(topologyNode);
        } else if ("topology-edge".equals(qName)) {
            TopologyEdge topologyEdge = this.m_maker.buildTopologyEdge(attributes);
            this.m_linker.onTopologyEdge(parentObj, topologyEdge);
            this.m_objs.push(topologyEdge);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under topology-graph!", qName));
        }
        this.m_tags.push(qName);
    }

    private void parseForTopologyNode(TopologyNode parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseRoot(String qName, Attributes attributes) throws SAXException {
        if ("topology-graph".equals(qName)) {
            TopologyGraph topologyGraph = this.m_maker.buildTopologyGraph(attributes);
            this.m_entity = topologyGraph;
            this.m_objs.push(topologyGraph);
            this.m_tags.push(qName);
        } else if ("topology-node".equals(qName)) {
            TopologyNode topologyNode = this.m_maker.buildTopologyNode(attributes);
            this.m_entity = topologyNode;
            this.m_objs.push(topologyNode);
            this.m_tags.push(qName);
        } else if ("topology-edge".equals(qName)) {
            TopologyEdge topologyEdge = this.m_maker.buildTopologyEdge(attributes);
            this.m_entity = topologyEdge;
            this.m_objs.push(topologyEdge);
            this.m_tags.push(qName);
        } else {
            throw new SAXException("Unknown root element(" + qName + ") found!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && uri.length() != 0) throw new SAXException(String.format("Namespace(%s) is not supported by %s.", uri, this.getClass().getName()));
        if (this.m_objs.isEmpty()) {
            this.parseRoot(qName, attributes);
        } else {
            Object parent = this.m_objs.peek();
            String tag = (String)this.m_tags.peek();
            if (parent instanceof TopologyGraph) {
                this.parseForTopologyGraph((TopologyGraph)parent, tag, qName, attributes);
            } else if (parent instanceof TopologyNode) {
                this.parseForTopologyNode((TopologyNode)parent, tag, qName, attributes);
            } else {
                if (!(parent instanceof TopologyEdge)) throw new RuntimeException(String.format("Unknown entity(%s) under %s!", qName, parent.getClass().getName()));
                this.parseForTopologyEdge((TopologyEdge)parent, tag, qName, attributes);
            }
        }
        this.m_text.setLength(0);
    }
}

