/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.graph.entity;

import com.dianping.cat.home.graph.BaseEntity;
import com.dianping.cat.home.graph.IVisitor;
import com.dianping.cat.home.graph.entity.Item;
import java.util.LinkedHashMap;
import java.util.Map;

public class Graph
extends BaseEntity<Graph> {
    private String m_id;
    private Map<String, Item> m_items = new LinkedHashMap();

    public Graph() {
    }

    public Graph(String id) {
        this.m_id = id;
    }

    public void accept(IVisitor visitor) {
        visitor.visitGraph(this);
    }

    public Graph addItem(Item item) {
        this.m_items.put(item.getId(), item);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Graph) {
            Graph _o = (Graph)obj;
            return this.equals((Object)this.getId(), (Object)_o.getId());
        }
        return false;
    }

    public Item findItem(String id) {
        return (Item)this.m_items.get(id);
    }

    public String getId() {
        return this.m_id;
    }

    public Map<String, Item> getItems() {
        return this.m_items;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    public void mergeAttributes(Graph other) {
        this.assertAttributeEquals((Object)other, "graph", "id", (Object)this.m_id, (Object)other.getId());
    }

    public Item removeItem(String id) {
        return (Item)this.m_items.remove(id);
    }

    public Graph setId(String id) {
        this.m_id = id;
        return this;
    }
}

