/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.group.transform;

import com.dianping.cat.home.group.IEntity;
import com.dianping.cat.home.group.entity.Domain;
import com.dianping.cat.home.group.entity.DomainGroup;
import com.dianping.cat.home.group.entity.Group;
import com.dianping.cat.home.group.transform.DefaultLinker;
import com.dianping.cat.home.group.transform.DefaultSaxMaker;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultSaxParser
extends DefaultHandler {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DefaultSaxMaker m_maker = new DefaultSaxMaker();
    private Stack<String> m_tags = new Stack();
    private Stack<Object> m_objs = new Stack();
    private IEntity<?> m_entity;
    private StringBuilder m_text = new StringBuilder();

    public static DomainGroup parse(InputStream in) throws SAXException, IOException {
        return (DomainGroup)DefaultSaxParser.parseEntity(DomainGroup.class, (InputSource)new InputSource((InputStream)DefaultSaxParser.removeBOM((Object)in)));
    }

    public static DomainGroup parse(Reader reader) throws SAXException, IOException {
        return (DomainGroup)DefaultSaxParser.parseEntity(DomainGroup.class, (InputSource)new InputSource((Reader)DefaultSaxParser.removeBOM((Object)reader)));
    }

    public static DomainGroup parse(String xml) throws SAXException, IOException {
        return (DomainGroup)DefaultSaxParser.parseEntity(DomainGroup.class, (InputSource)new InputSource(new StringReader((String)DefaultSaxParser.removeBOM((Object)xml))));
    }

    private static <T extends IEntity<?>> T parseEntity(Class<T> type, InputSource is) throws SAXException, IOException {
        try {
            DefaultSaxParser handler = new DefaultSaxParser();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.newSAXParser().parse(is, (DefaultHandler)handler);
            return (T)handler.getEntity();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to get SAX parser instance!", e);
        }
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, InputStream in) throws SAXException, IOException {
        return (T)DefaultSaxParser.parseEntity(type, (InputSource)new InputSource((InputStream)DefaultSaxParser.removeBOM((Object)in)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, String xml) throws SAXException, IOException {
        return (T)DefaultSaxParser.parseEntity(type, (InputSource)new InputSource(new StringReader((String)DefaultSaxParser.removeBOM((Object)xml))));
    }

    private static <T> T removeBOM(T obj) throws IOException {
        if (obj instanceof String) {
            String str = (String)obj;
            if (str.length() != 0 && str.charAt(0) == '\ufeff') {
                return (T)str.substring(1);
            }
            return obj;
        }
        if (obj instanceof InputStream) {
            BufferedInputStream in = new BufferedInputStream((InputStream)obj);
            in.mark(3);
            if (in.read() != 239 || in.read() != 187 || in.read() != 191) {
                in.reset();
            }
            return (T)in;
        }
        if (obj instanceof Reader) {
            BufferedReader in = new BufferedReader((Reader)obj);
            in.mark(1);
            if (in.read() != 65279) {
                in.reset();
            }
            return (T)in;
        }
        return obj;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_text.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.m_linker.finish();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri == null || uri.length() == 0) {
            Object currentObj = this.m_objs.pop();
            String currentTag = (String)this.m_tags.pop();
            if (currentObj instanceof Group) {
                Group group = (Group)currentObj;
                if ("ip".equals(currentTag)) {
                    group.addIp(this.getText());
                }
            }
        }
        this.m_text.setLength(0);
    }

    private IEntity<?> getEntity() {
        return this.m_entity;
    }

    protected String getText() {
        return this.m_text.toString();
    }

    private void parseForDomain(Domain parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"group".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under domain!", qName));
        }
        Group group = this.m_maker.buildGroup(attributes);
        this.m_linker.onGroup(parentObj, group);
        this.m_objs.push(group);
        this.m_tags.push(qName);
    }

    private void parseForDomainGroup(DomainGroup parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"domain".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under domain-group!", qName));
        }
        Domain domain = this.m_maker.buildDomain(attributes);
        this.m_linker.onDomain(parentObj, domain);
        this.m_objs.push(domain);
        this.m_tags.push(qName);
    }

    private void parseForGroup(Group parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"ips".equals(qName) && !"ip".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under group!", qName));
        }
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseRoot(String qName, Attributes attributes) throws SAXException {
        if ("domain-group".equals(qName)) {
            DomainGroup domainGroup = this.m_maker.buildDomainGroup(attributes);
            this.m_entity = domainGroup;
            this.m_objs.push(domainGroup);
            this.m_tags.push(qName);
        } else if ("domain".equals(qName)) {
            Domain domain = this.m_maker.buildDomain(attributes);
            this.m_entity = domain;
            this.m_objs.push(domain);
            this.m_tags.push(qName);
        } else if ("group".equals(qName)) {
            Group group = this.m_maker.buildGroup(attributes);
            this.m_entity = group;
            this.m_objs.push(group);
            this.m_tags.push(qName);
        } else {
            throw new SAXException("Unknown root element(" + qName + ") found!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && uri.length() != 0) throw new SAXException(String.format("Namespace(%s) is not supported by %s.", uri, this.getClass().getName()));
        if (this.m_objs.isEmpty()) {
            this.parseRoot(qName, attributes);
        } else {
            Object parent = this.m_objs.peek();
            String tag = (String)this.m_tags.peek();
            if (parent instanceof DomainGroup) {
                this.parseForDomainGroup((DomainGroup)parent, tag, qName, attributes);
            } else if (parent instanceof Domain) {
                this.parseForDomain((Domain)parent, tag, qName, attributes);
            } else {
                if (!(parent instanceof Group)) throw new RuntimeException(String.format("Unknown entity(%s) under %s!", qName, parent.getClass().getName()));
                this.parseForGroup((Group)parent, tag, qName, attributes);
            }
        }
        this.m_text.setLength(0);
    }
}

