/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.router.entity;

import com.dianping.cat.home.router.BaseEntity;
import com.dianping.cat.home.router.IVisitor;
import com.dianping.cat.home.router.entity.Group;
import java.util.LinkedHashMap;
import java.util.Map;

public class Domain
extends BaseEntity<Domain> {
    private String m_id;
    private Map<String, Group> m_groups = new LinkedHashMap();

    public Domain() {
    }

    public Domain(String id) {
        this.m_id = id;
    }

    public void accept(IVisitor visitor) {
        visitor.visitDomain(this);
    }

    public Domain addGroup(Group group) {
        this.m_groups.put(group.getId(), group);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Domain) {
            Domain _o = (Domain)obj;
            return this.equals((Object)this.getId(), (Object)_o.getId());
        }
        return false;
    }

    public Group findGroup(String id) {
        return (Group)this.m_groups.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group findOrCreateGroup(String id) {
        Group group = (Group)this.m_groups.get(id);
        if (group == null) {
            Map map = this.m_groups;
            synchronized (map) {
                group = (Group)this.m_groups.get(id);
                if (group == null) {
                    group = new Group(id);
                    this.m_groups.put(id, group);
                }
            }
        }
        return group;
    }

    public Map<String, Group> getGroups() {
        return this.m_groups;
    }

    public String getId() {
        return this.m_id;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    public void mergeAttributes(Domain other) {
        this.assertAttributeEquals((Object)other, "domain", "id", (Object)this.m_id, (Object)other.getId());
    }

    public Group removeGroup(String id) {
        return (Group)this.m_groups.remove(id);
    }

    public Domain setId(String id) {
        this.m_id = id;
        return this;
    }
}

