/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.home.router.entity;

import com.dianping.cat.home.router.BaseEntity;
import com.dianping.cat.home.router.IVisitor;
import com.dianping.cat.home.router.entity.GroupServer;
import java.util.LinkedHashMap;
import java.util.Map;

public class ServerGroup
extends BaseEntity<ServerGroup> {
    private String m_id;
    private String m_title;
    private Map<String, GroupServer> m_groupServers = new LinkedHashMap();

    public ServerGroup() {
    }

    public ServerGroup(String id) {
        this.m_id = id;
    }

    public void accept(IVisitor visitor) {
        visitor.visitServerGroup(this);
    }

    public ServerGroup addGroupServer(GroupServer groupServer) {
        this.m_groupServers.put(groupServer.getId(), groupServer);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServerGroup) {
            ServerGroup _o = (ServerGroup)obj;
            return this.equals((Object)this.getId(), (Object)_o.getId());
        }
        return false;
    }

    public GroupServer findGroupServer(String id) {
        return (GroupServer)this.m_groupServers.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupServer findOrCreateGroupServer(String id) {
        GroupServer groupServer = (GroupServer)this.m_groupServers.get(id);
        if (groupServer == null) {
            Map map = this.m_groupServers;
            synchronized (map) {
                groupServer = (GroupServer)this.m_groupServers.get(id);
                if (groupServer == null) {
                    groupServer = new GroupServer(id);
                    this.m_groupServers.put(id, groupServer);
                }
            }
        }
        return groupServer;
    }

    public Map<String, GroupServer> getGroupServers() {
        return this.m_groupServers;
    }

    public String getId() {
        return this.m_id;
    }

    public String getTitle() {
        return this.m_title;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    public void mergeAttributes(ServerGroup other) {
        this.assertAttributeEquals((Object)other, "server-group", "id", (Object)this.m_id, (Object)other.getId());
        if (other.getTitle() != null) {
            this.m_title = other.getTitle();
        }
    }

    public GroupServer removeGroupServer(String id) {
        return (GroupServer)this.m_groupServers.remove(id);
    }

    public ServerGroup setId(String id) {
        this.m_id = id;
        return this;
    }

    public ServerGroup setTitle(String title) {
        this.m_title = title;
        return this;
    }
}

